/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.optel.resources.grpc;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;
import org.mule.runtime.tracer.impl.exporter.config.SpanExporterConfigurationUtils;
import org.mule.runtime.tracer.impl.exporter.optel.resources.SpanExporterConfigurator;
import org.mule.runtime.tracer.impl.exporter.optel.resources.SpanExporterConfiguratorException;

public class GrpcSpanExporterConfigurator
implements SpanExporterConfigurator {
    @Override
    public SpanExporter configExporter(SpanExporterConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String timeout;
        String headers;
        String type;
        String endpoint = spanExporterConfiguration.getValue("mule.open.telemetry.exporter.endpoint");
        OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
        if (!StringUtils.isEmpty((CharSequence)endpoint)) {
            builder.setEndpoint(endpoint);
        }
        if ((type = spanExporterConfiguration.getValue("mule.open.telemetry.exporter.compression.type")) != null) {
            builder.setCompression(type);
        }
        if (Boolean.parseBoolean(spanExporterConfiguration.getValue("mule.open.telemetry.exporter.tls.enabled", "false"))) {
            this.configureTls(builder, spanExporterConfiguration);
        }
        if ((headers = spanExporterConfiguration.getValue("mule.open.telemetry.exporter.headers")) != null) {
            this.configureHeaders(builder, headers);
        }
        if ((timeout = spanExporterConfiguration.getValue("mule.open.telemetry.exporter.timeout")) != null) {
            this.configureTimeout(builder, timeout);
        }
        SpanExporterConfigurationUtils.enableBackoffStrategy(builder, spanExporterConfiguration);
        return builder.build();
    }

    private void configureTimeout(OtlpGrpcSpanExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpGrpcSpanExporterBuilder builder, String headers) throws SpanExporterConfiguratorException {
        try {
            Map retMap = (Map)new Gson().fromJson(headers, new TypeToken<HashMap<String, Object>>(){}.getType());
            retMap.forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
        }
        catch (Exception e) {
            throw new SpanExporterConfiguratorException(e);
        }
    }

    private void configureTls(OtlpGrpcSpanExporterBuilder builder, SpanExporterConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        GrpcSpanExporterConfigurator.configureTrustedCertificates(builder, spanExporterConfiguration);
        this.configureClientTls(builder, spanExporterConfiguration);
    }

    private static void configureTrustedCertificates(OtlpGrpcSpanExporterBuilder builder, SpanExporterConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String caFilePath = spanExporterConfiguration.getValue("mule.open.telemetry.exporter.ca.file.location");
        if (caFilePath != null) {
            try {
                byte[] caFileBytes = Files.readAllBytes(Paths.get(caFilePath, new String[0]));
                builder.setTrustedCertificates(caFileBytes);
            }
            catch (IOException e) {
                throw new SpanExporterConfiguratorException(e);
            }
        }
    }

    private void configureClientTls(OtlpGrpcSpanExporterBuilder builder, SpanExporterConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String certFilePath = spanExporterConfiguration.getValue("mule.open.telemetry.exporter.cert.file.location");
        String keyFilePath = spanExporterConfiguration.getValue("mule.open.telemetry.exporter.key.file.location");
        if (certFilePath != null && keyFilePath != null) {
            try {
                byte[] keyFileBytes = Files.readAllBytes(Paths.get(keyFilePath, new String[0]));
                byte[] certFileBytes = Files.readAllBytes(Paths.get(certFilePath, new String[0]));
                builder.setClientTls(keyFileBytes, certFileBytes);
            }
            catch (IOException e) {
                throw new SpanExporterConfiguratorException(e);
            }
        }
    }
}

