/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.config;

import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;

public class SpanExporterConfigurationUtils {
    private SpanExporterConfigurationUtils() {
    }

    public static void enableBackoffStrategy(Object exporterBuilder, SpanExporterConfiguration spanExporterConfiguration) {
        try {
            Field delegateField = exporterBuilder.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            Method setRetryPolicyMethod = delegateField.get(exporterBuilder).getClass().getDeclaredMethod("setRetryPolicy", RetryPolicy.class);
            setRetryPolicyMethod.setAccessible(true);
            setRetryPolicyMethod.invoke(delegateField.get(exporterBuilder), new RetryPolicyBuilder(spanExporterConfiguration).build());
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)new IllegalArgumentException("Unable to set the RetryPolicy reflectively.", e));
        }
    }

    private static class RetryPolicyBuilder {
        private static final String DEFAULT_BACKOFF_MULTIPLIER = "1.5";
        private static final String DEFAULT_INITIAL_BACKOFF = "1";
        private static final String DEFAULT_MAXIMUM_BACKOFF = "5";
        private static final String DEFAULT_MAX_ATTEMPTS = "5";
        private final SpanExporterConfiguration spanExporterConfiguration;

        public RetryPolicyBuilder(SpanExporterConfiguration spanExporterConfiguration) {
            this.spanExporterConfiguration = spanExporterConfiguration;
        }

        public RetryPolicy build() {
            return RetryPolicy.builder().setBackoffMultiplier(Double.parseDouble(this.spanExporterConfiguration.getValue("mule.open.telemetry.exporterbackoff.multiplier", DEFAULT_BACKOFF_MULTIPLIER))).setInitialBackoff(Duration.ofSeconds(Long.parseLong(this.spanExporterConfiguration.getValue("mule.open.telemetry.exporter.backoff.initial", DEFAULT_INITIAL_BACKOFF)))).setMaxBackoff(Duration.ofSeconds(Long.parseLong(this.spanExporterConfiguration.getValue("mule.open.telemetry.exporterbackoff.max", "5")))).setMaxAttempts(Integer.parseInt(this.spanExporterConfiguration.getValue("mule.open.telemetry.exporterbackoff.max.attempts", "5"))).build();
        }
    }
}

