/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.config;

import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;
import org.mule.runtime.tracer.impl.exporter.config.SystemPropertiesSpanExporterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanExporterConfigurationDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpanExporterConfigurationDiscoverer.class);
    public static final SystemPropertiesSpanExporterConfiguration SYSTEM_PROPERTIES_SPAN_EXPORTER_CONFIGURATION = new SystemPropertiesSpanExporterConfiguration();

    private SpanExporterConfigurationDiscoverer() {
    }

    public static SpanExporterConfiguration discoverSpanExporterConfiguration() {
        try {
            SpanExporterConfiguration discoveredSpanExporterConfiguration = (SpanExporterConfiguration)new SpiServiceRegistry().lookupProvider(SpanExporterConfiguration.class, SpanExporterConfiguration.class.getClassLoader());
            if (discoveredSpanExporterConfiguration == null) {
                LOGGER.warn("No configuration for optel export was found. Using system properties");
                return SYSTEM_PROPERTIES_SPAN_EXPORTER_CONFIGURATION;
            }
            return discoveredSpanExporterConfiguration;
        }
        catch (IllegalStateException e) {
            LOGGER.warn("An exception was raised while trying to find the exporter configuration", (Throwable)e);
            LOGGER.warn("No configuration for optel export was found. Using system properties");
            return SYSTEM_PROPERTIES_SPAN_EXPORTER_CONFIGURATION;
        }
    }
}

