/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;

public class FileSpanExporterConfiguration
implements SpanExporterConfiguration {
    private static final String PROPERTIES_FILE_NAME = "tracer-exporter.conf";
    private final ConfigurationPropertiesResolver propertyResolver;
    private final Properties properties = this.getSpanExporterConfiguration();

    public FileSpanExporterConfiguration() {
        this.propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider());
    }

    public String getValue(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return this.propertyResolver.apply(this.properties.getProperty(key));
        }
        return null;
    }

    private Properties getSpanExporterConfiguration() {
        try {
            InputStream is = IOUtils.getResourceAsStream((String)(this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName()), FileSpanExporterConfiguration.class);
            return FileSpanExporterConfiguration.loadProperties(is);
        }
        catch (IOException e) {
            return System.getProperties();
        }
    }

    protected String getConfFolder() {
        return MuleFoldersUtil.getConfFolder().getAbsolutePath();
    }

    protected String getPropertiesFileName() {
        return PROPERTIES_FILE_NAME;
    }

    public static Properties loadProperties(InputStream is) throws IOException {
        if (is == null) {
            I18nMessage error = CoreMessages.objectIsNull((String)"input stream");
            throw new IOException(error.toString());
        }
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }
}

