/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.internal.BitronixRuntimeException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class MessageProducerConsumerKey {
    private final Destination destination;
    private final String messageSelector;
    private final Boolean noLocal;

    public MessageProducerConsumerKey(Destination destination) {
        this.destination = destination;
        this.messageSelector = null;
        this.noLocal = null;
    }

    public MessageProducerConsumerKey(Destination destination, String messageSelector) {
        this.destination = destination;
        this.messageSelector = messageSelector;
        this.noLocal = null;
    }

    public MessageProducerConsumerKey(Destination destination, String messageSelector, boolean noLocal) {
        this.destination = destination;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageProducerConsumerKey) {
            MessageProducerConsumerKey otherKey = (MessageProducerConsumerKey)obj;
            if (!MessageProducerConsumerKey.areEquals(this.getDestinationName(), otherKey.getDestinationName())) {
                return false;
            }
            if (!MessageProducerConsumerKey.areEquals(this.messageSelector, otherKey.messageSelector)) {
                return false;
            }
            return MessageProducerConsumerKey.areEquals(this.noLocal, otherKey.noLocal);
        }
        return false;
    }

    private static boolean areEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private String getDestinationName() {
        if (this.destination == null) {
            return null;
        }
        if (this.destination instanceof Queue) {
            try {
                return ((Queue)this.destination).getQueueName();
            }
            catch (JMSException ex) {
                throw new BitronixRuntimeException("error getting queue name of " + this.destination, ex);
            }
        }
        if (this.destination instanceof Topic) {
            try {
                return ((Topic)this.destination).getTopicName();
            }
            catch (JMSException ex) {
                throw new BitronixRuntimeException("error getting topic name of " + this.destination, ex);
            }
        }
        throw new IllegalArgumentException("unsupported destination: " + this.destination);
    }

    public int hashCode() {
        return MessageProducerConsumerKey.hash(this.getDestinationName()) + MessageProducerConsumerKey.hash(this.messageSelector) + MessageProducerConsumerKey.hash(this.noLocal);
    }

    private static int hash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public String toString() {
        return "a MessageProducerConsumerKey on " + this.destination + (this.messageSelector == null ? "" : " with selector '" + this.messageSelector + "'") + (this.noLocal == null ? "" : " and noLocal=" + this.noLocal);
    }
}

