/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser.utils;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.core.internal.type.catalog.DefaultArtifactTypeLoader;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;

public class MuleSdkExtensionLoadingUtils {
    public static <T> T getRequiredLoadingParameter(ExtensionLoadingContext context, String parameterName) {
        return context.getParameter(parameterName).orElseThrow(() -> MuleSdkExtensionLoadingUtils.createParameterNotFoundException(parameterName));
    }

    public static TypeLoader createTypeLoader(ExtensionLoadingContext context) {
        ExpressionLanguageMetadataService expressionLanguageMetadataService = (ExpressionLanguageMetadataService)MuleSdkExtensionLoadingUtils.getRequiredLoadingParameter(context, "muleSDK.expressionLanguageMetadataService");
        DefaultArtifactTypeLoader typeLoader = new DefaultArtifactTypeLoader((Collection)context.getDslResolvingContext().getExtensions());
        try {
            typeLoader.initialise();
        }
        catch (InitialisationException initialisationException) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to initialise type loader."), (Throwable)initialisationException);
        }
        return typeLoader;
    }

    public static ExtensionModelHelper createExtensionModelHelper(ExtensionLoadingContext context) {
        return new ExtensionModelHelper(context.getDslResolvingContext().getExtensions(), context.getDslResolvingContext());
    }

    private static RuntimeException createParameterNotFoundException(String parameterName) {
        return new NoSuchElementException(String.format("Parameter '%s' not found in context", parameterName));
    }

    private MuleSdkExtensionLoadingUtils() {
    }
}

