/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.notification.BatchNotification;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.commit.ImmutableRecordAwareList;
import com.mulesoft.mule.runtime.module.batch.internal.engine.BatchProcessingTemplate;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.AggregatorRecordBuffer;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.PartialErrorMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.tracer.api.EventTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAggregatorRecordBuffer
extends AggregatorRecordBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedAggregatorRecordBuffer.class);
    private final boolean preserveMimeTypes;
    private final PartialErrorMatcher partialErrorMatcher;

    public FixedAggregatorRecordBuffer(int blockSize, boolean preserveMimeTypes, BatchEngine batchEngine, BatchStepAdapter step, Processor chain, ComponentLocation location, NotificationDispatcher notificationDispatcher, MuleContext muleContext, EventTracer<CoreEvent> coreEventTracer) {
        super(String.format("batch-step-%s-fixed-aggregator-buffer", step.getName()), blockSize, batchEngine, step, chain, location, notificationDispatcher, muleContext, coreEventTracer);
        this.preserveMimeTypes = preserveMimeTypes;
        this.partialErrorMatcher = new PartialErrorMatcher(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(BatchJobInstanceAdapter jobInstance) {
        Object object = this.getHolderLock();
        synchronized (object) {
            this.flush(jobInstance);
            super.forget(jobInstance);
        }
    }

    @Override
    protected CoreEvent configureChainEvent(CoreEvent event, BatchJobInstanceAdapter jobInstance, Multimap<BatchTransactionContext, Record> records) {
        ImmutableList actualRecords = ImmutableList.copyOf((Collection)records.values());
        ArrayList<TypedValue<Object>> payload = new ArrayList<TypedValue<Object>>(actualRecords.size());
        if (this.preserveMimeTypes) {
            boolean allMimeTypesMatch = true;
            boolean firstRecord = true;
            MediaType itemsMediaType = null;
            for (Record record : actualRecords) {
                TypedValue<Object> recordPayload = record.getPayload();
                MediaType recordType = recordPayload.getDataType().getMediaType();
                if (firstRecord) {
                    itemsMediaType = recordType;
                    firstRecord = false;
                } else if (!this.matches(itemsMediaType, recordType)) {
                    allMimeTypesMatch = false;
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Aggregator in step {} received records of mixed MediaTypes. Some DataWeave transformations may not work correctly. Please review the job's design", (Object)this.step.getName());
                    }
                }
                payload.add(recordPayload);
            }
            Message.Builder messageBuilder = Message.builder((Message)event.getMessage());
            Message.CollectionBuilder collectionBuilder = messageBuilder.collectionValue(new ImmutableRecordAwareList(Collections.unmodifiableList(payload), (List<Record>)actualRecords), Object.class);
            DataType variableDataType = null;
            if (allMimeTypesMatch && itemsMediaType != null) {
                collectionBuilder.itemMediaType(itemsMediaType);
                variableDataType = DataType.builder().collectionType(List.class).itemMediaType(itemsMediaType).build();
            }
            CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event).message(collectionBuilder.build());
            if (variableDataType != null) {
                eventBuilder.addVariable("records", (Object)actualRecords, variableDataType);
            } else {
                eventBuilder.addVariable("records", (Object)actualRecords);
            }
            return eventBuilder.build();
        }
        actualRecords.forEach(r -> {
            boolean bl = payload.add((TypedValue<Object>)r.getPayload().getValue());
        });
        Message.Builder messageBuilder = Message.builder((Message)event.getMessage());
        Message.CollectionBuilder collectionBuilder = messageBuilder.collectionValue(new ImmutableRecordAwareList(Collections.unmodifiableList(payload), (List<Record>)actualRecords), Object.class);
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event).message(collectionBuilder.build());
        eventBuilder.addVariable("records", (Object)actualRecords);
        return eventBuilder.build();
    }

    private boolean matches(MediaType m1, MediaType m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 != null && m2 != null) {
            return m1.matches(m2);
        }
        return false;
    }

    @Override
    protected BatchProcessingTemplate makeProcessingTemplate(final Multimap<BatchTransactionContext, Record> contexts, Processor processor, MuleContext muleContext) {
        return new BatchProcessingTemplate((ReactiveProcessor)processor, this.getLocation(), muleContext.getFlowTraceManager(), muleContext.getStreamCloserService()){
            private final List<Record> records;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.records = ImmutableList.copyOf((Collection)multimap.values());
            }

            @Override
            protected void onSuccess(BatchJobInstanceAdapter jobInstance, CoreEvent responseEvent) throws MuleException {
                FixedAggregatorRecordBuffer.this.matchPartialErrors(jobInstance, this.records, responseEvent);
            }

            @Override
            protected void onException(BatchJobInstanceAdapter jobInstance, Exception e, CoreEvent event) throws MuleException {
                FixedAggregatorRecordBuffer.this.markError(jobInstance, this.records, e);
            }

            @Override
            protected void onFinally(BatchJobInstanceAdapter jobInstance, CoreEvent originalEvent, CoreEvent resultEvent) throws MuleException {
                for (Map.Entry entry : contexts.asMap().entrySet()) {
                    BatchTransactionContext ctx = (BatchTransactionContext)entry.getKey();
                    FixedAggregatorRecordBuffer.this.batchEngine.updateStatisticsAndRoute(ctx, (List<Record>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
                }
                super.onFinally(jobInstance, originalEvent, resultEvent);
            }
        };
    }

    private void matchPartialErrors(BatchJobInstanceAdapter jobInstance, List<Record> records, CoreEvent event) {
        try {
            this.partialErrorMatcher.match(records, event);
            this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, this.step, BatchNotification.STEP_AGGREGATOR_END));
        }
        catch (Exception e) {
            this.markError(jobInstance, records, e);
        }
    }
}

