/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.internal.DefaultRepositoryService;
import org.mule.runtime.module.repository.internal.SpiRepositorySystemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryServiceFactory {
    public static final String MULE_REPOSITORY_FOLDER_PROPERTY = "mule.repository.folder";
    public static final String MULE_REMOTE_REPOSITORIES_PROPERTY = "mule.repository.repositories";
    private static final String REPOSITORY_FOLDER = "repository";
    private static final String DEFAULT_REPOSITORY_TYPE = "default";
    private static final Logger logger = LoggerFactory.getLogger(DefaultRepositoryService.class);

    public RepositoryService createRepositoryService() {
        RepositorySystem repositorySystem = new SpiRepositorySystemFactory().createRepositorySystem();
        File repositoryFolder = this.createRepositoryFolderIfDoesNotExists();
        List<RemoteRepository> remoteRepositories = this.collectRemoteRepositories();
        DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession();
        repositorySystemSession.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, new LocalRepository(repositoryFolder)));
        return new DefaultRepositoryService(repositorySystem, repositorySystemSession, remoteRepositories);
    }

    private List<RemoteRepository> collectRemoteRepositories() {
        String[] remoteRepositoriesArray = System.getProperty(MULE_REMOTE_REPOSITORIES_PROPERTY, "").split(",");
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        for (String remoteRepository : remoteRepositoriesArray) {
            if (remoteRepository.trim().equals("")) continue;
            remoteRepositories.add(new RemoteRepository.Builder(remoteRepository, DEFAULT_REPOSITORY_TYPE, remoteRepository.trim()).build());
        }
        return remoteRepositories;
    }

    private File createRepositoryFolderIfDoesNotExists() {
        File repositoryFolder = this.resolveRepositoryFolder();
        this.createRepositoryFolder(repositoryFolder);
        return repositoryFolder;
    }

    private void createRepositoryFolder(File repositoryFolder) {
        if (!repositoryFolder.exists() && !repositoryFolder.mkdirs()) {
            throw new RuntimeException("Could not create dependencies folder with path " + repositoryFolder.getAbsolutePath());
        }
    }

    private File resolveRepositoryFolder() {
        String userDefinedDependenciesFolder = System.getProperty(MULE_REPOSITORY_FOLDER_PROPERTY);
        File repositoryFolder = userDefinedDependenciesFolder != null ? new File(userDefinedDependenciesFolder) : new File(MuleContainerBootstrapUtils.getMuleLibDir(), REPOSITORY_FOLDER);
        if (logger.isDebugEnabled()) {
            logger.debug("Using dependencies folder " + repositoryFolder.getAbsolutePath());
        }
        return repositoryFolder;
    }
}

