/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.artifact.activation.internal;

import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public class TrackingArtifactClassLoaderResolverDecorator
implements ArtifactClassLoaderResolver {
    private final ArtifactClassLoaderManager artifactClassLoaderManager;
    private final ArtifactClassLoaderResolver delegate;

    public TrackingArtifactClassLoaderResolverDecorator(ArtifactClassLoaderManager artifactClassLoaderManager, ArtifactClassLoaderResolver delegate) {
        this.artifactClassLoaderManager = Objects.requireNonNull(artifactClassLoaderManager, "artifactClassLoaderManager");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public MuleDeployableArtifactClassLoader createDomainClassLoader(DomainDescriptor descriptor) {
        MuleDeployableArtifactClassLoader artifactClassLoader = this.delegate.createDomainClassLoader(descriptor);
        this.trackDeployableArtifactClassLoader(artifactClassLoader);
        return artifactClassLoader;
    }

    public MuleDeployableArtifactClassLoader createDomainClassLoader(DomainDescriptor descriptor, PluginClassLoaderResolver pluginClassLoaderResolver) {
        MuleDeployableArtifactClassLoader artifactClassLoader = this.delegate.createDomainClassLoader(descriptor, pluginClassLoaderResolver);
        this.trackDeployableArtifactClassLoader(artifactClassLoader);
        return artifactClassLoader;
    }

    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor) {
        MuleDeployableArtifactClassLoader artifactClassLoader = this.delegate.createApplicationClassLoader(descriptor);
        this.trackDeployableArtifactClassLoader(artifactClassLoader);
        return artifactClassLoader;
    }

    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, PluginClassLoaderResolver pluginClassLoaderResolver) {
        MuleDeployableArtifactClassLoader artifactClassLoader = this.delegate.createApplicationClassLoader(descriptor, pluginClassLoaderResolver);
        this.trackDeployableArtifactClassLoader(artifactClassLoader);
        return artifactClassLoader;
    }

    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, Supplier<ArtifactClassLoader> domainClassLoader) {
        MuleDeployableArtifactClassLoader artifactClassLoader = this.delegate.createApplicationClassLoader(descriptor, domainClassLoader);
        this.trackDeployableArtifactClassLoader(artifactClassLoader);
        return artifactClassLoader;
    }

    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, Supplier<ArtifactClassLoader> domainClassLoader, PluginClassLoaderResolver pluginClassLoaderResolver) {
        MuleDeployableArtifactClassLoader artifactClassLoader = this.delegate.createApplicationClassLoader(descriptor, domainClassLoader, pluginClassLoaderResolver);
        this.trackDeployableArtifactClassLoader(artifactClassLoader);
        return artifactClassLoader;
    }

    public MuleArtifactClassLoader createMulePluginClassLoader(MuleDeployableArtifactClassLoader ownerArtifactClassLoader, ArtifactPluginDescriptor descriptor, PluginDescriptorResolver pluginDescriptorResolver) {
        MuleArtifactClassLoader mulePluginClassLoader = this.delegate.createMulePluginClassLoader(ownerArtifactClassLoader, descriptor, pluginDescriptorResolver);
        this.track((ArtifactClassLoader)mulePluginClassLoader);
        return mulePluginClassLoader;
    }

    public MuleArtifactClassLoader createMulePluginClassLoader(MuleDeployableArtifactClassLoader ownerArtifactClassLoader, ArtifactPluginDescriptor descriptor, PluginDescriptorResolver pluginDescriptorResolver, PluginClassLoaderResolver pluginClassLoaderResolver) {
        MuleArtifactClassLoader mulePluginClassLoader = this.delegate.createMulePluginClassLoader(ownerArtifactClassLoader, descriptor, pluginDescriptorResolver, pluginClassLoaderResolver);
        this.track((ArtifactClassLoader)mulePluginClassLoader);
        return mulePluginClassLoader;
    }

    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, PluginClassLoaderResolver pluginClassLoaderResolver, List<URL> additionalClassloaderUrls) {
        throw new UnsupportedOperationException("Mule Server does not support loading additional classpath entries.");
    }

    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, Supplier<ArtifactClassLoader> domainClassLoader, PluginClassLoaderResolver pluginClassLoaderResolver, List<URL> additionalClassloaderUrls) {
        throw new UnsupportedOperationException("Mule Server does not support loading additional classpath entries.");
    }

    private void trackDeployableArtifactClassLoader(MuleDeployableArtifactClassLoader artifactClassLoader) {
        artifactClassLoader.getArtifactPluginClassLoaders().forEach(this::track);
        this.track((ArtifactClassLoader)artifactClassLoader);
    }

    private void track(ArtifactClassLoader artifactClassLoader) {
        this.artifactClassLoaderManager.register(artifactClassLoader);
        artifactClassLoader.addShutdownListener(() -> this.artifactClassLoaderManager.unregister(artifactClassLoader.getArtifactId()));
    }
}

