/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.dexx;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.andrewoma.dexx.collection.IndexedLists;
import com.github.andrewoma.dexx.collection.List;

public class ListSerializer
extends Serializer<List> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;

    public ListSerializer() {
        super(true, true);
    }

    public void write(Kryo kryo, Output output, List object) {
        output.writeInt(object.size(), true);
        for (Object elm : object) {
            kryo.writeClassAndObject(output, elm);
        }
    }

    public List<Object> read(Kryo kryo, Input input, Class<List> aClass) {
        int size = input.readInt(true);
        Object[] list = new Object[size];
        for (int i = 0; i < size; ++i) {
            list[i] = kryo.readClassAndObject(input);
        }
        return IndexedLists.copyOf((Object[])list);
    }

    public static void registerSerializers(Kryo kryo) {
        ListSerializer serializer = new ListSerializer();
        kryo.register(List.class, (Serializer)serializer);
        kryo.register(IndexedLists.of().getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)10).getClass(), (Serializer)serializer);
        kryo.register(IndexedLists.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)10, (Object)11).getClass(), (Serializer)serializer);
    }
}

