/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.ReflectionUtils;
import org.mule.tooling.client.api.artifact.declaration.request.XmlArtifactDeserializationRequest;

public class XmlArtifactDeserializationRequestConverter
implements Converter {
    private Mapper mapper;

    public XmlArtifactDeserializationRequestConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        XmlArtifactDeserializationRequest request = (XmlArtifactDeserializationRequest)source;
        writer.startNode("artifact-source");
        try {
            writer.setValue(Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)request.getArtifactSource())));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while serializing inputStream", e);
        }
        writer.endNode();
        writer.startNode("request-timeout");
        writer.setValue(String.valueOf(request.getRequestTimeout()));
        writer.endNode();
        String typeName = this.mapper.serializedClass(request.getPluginArtifactDescriptors().getClass());
        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)typeName, request.getPluginArtifactDescriptors().getClass());
        context.convertAnother(request.getPluginArtifactDescriptors());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        XmlArtifactDeserializationRequest request = new XmlArtifactDeserializationRequest(null, null);
        ByteArrayInputStream artifactSource = null;
        List pluginArtifactDescriptors = null;
        long requestTimeout = -1L;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("artifact-source".equals(reader.getNodeName())) {
                artifactSource = new ByteArrayInputStream(Base64.getDecoder().decode(reader.getValue()));
            } else if ("request-timeout".equals(reader.getNodeName())) {
                requestTimeout = Long.valueOf(reader.getValue());
            } else {
                pluginArtifactDescriptors = (List)context.convertAnother((Object)request, List.class);
            }
            reader.moveUp();
        }
        try {
            ReflectionUtils.setVariableValueInObject((Object)request, (String)"artifactSource", artifactSource);
            ReflectionUtils.setVariableValueInObject((Object)request, (String)"pluginArtifactDescriptors", pluginArtifactDescriptors);
            ReflectionUtils.setVariableValueInObject((Object)request, (String)"requestTimeout", (Object)requestTimeout);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while setting attributes for xmlArtifactDeserializationRequest using reflection", e);
        }
        return request;
    }

    public boolean canConvert(Class type) {
        return XmlArtifactDeserializationRequest.class.isAssignableFrom(type);
    }
}

