/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.XStreamFactory;
import org.mule.tooling.client.internal.serialization.XmlArtifactDeserializationRequestConverter;
import org.mule.tooling.client.internal.serialization.mapping.TypeAnnotationMapWriter;

public class XStreamClientSerializer
implements Serializer {
    public static String NAME = "xStream";
    private ClassLoader targetClassLoader;
    private List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient;

    public XStreamClientSerializer(ClassLoader targetClassLoader) {
        this.targetClassLoader = targetClassLoader;
        this.typeAnnotationsNotSupportedByToolingRuntimeClient = Collections.synchronizedList(new ArrayList());
    }

    private static XStream createXStream(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient) {
        XStream xStream = XStreamFactory.createXStream();
        xStream.registerConverter((Converter)new TypeAnnotationsMapConverter(targetClassLoader, typeAnnotationsNotSupportedByToolingRuntimeClient, xStream.getMapper()));
        xStream.registerConverter((Converter)new XmlArtifactDeserializationRequestConverter(xStream.getMapper()));
        xStream.ignoreUnknownElements();
        return xStream;
    }

    @Override
    public String serialize(Object object) {
        return XStreamClientSerializer.createXStream(this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient).toXML(object);
    }

    @Override
    public <T> T deserialize(String xml) {
        return (T)XStreamClientSerializer.createXStream(this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient).fromXML(xml);
    }

    private static class TypeAnnotationsMapConverter
    extends MapConverter {
        private TypeAnnotationMapWriter typeAnnotationMapWriter;

        public TypeAnnotationsMapConverter(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient, Mapper mapper) {
            super(mapper);
            this.typeAnnotationMapWriter = new TypeAnnotationMapWriter(targetClassLoader, typeAnnotationsNotSupportedByToolingRuntimeClient);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal((Object)this.typeAnnotationMapWriter.write((Map)source), writer, context);
        }
    }
}

