/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.configuration.ssl;

import java.io.File;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.mule.tooling.client.api.configuration.ssl.TrustStoreConfig;

public class ImmutableTrustStoreConfig
implements TrustStoreConfig {
    private final File trustStoreFile;
    private final String trustStorePassword;

    public ImmutableTrustStoreConfig(File trustStoreFile, String trustStorePassword) {
        Objects.requireNonNull(trustStoreFile, "trustStoreFile cannot be null");
        Objects.requireNonNull(trustStorePassword, "trustStorePassword cannot be null");
        this.trustStoreFile = trustStoreFile;
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String toString() {
        return String.format("%s{trustStoreFile=%s, trustStorePassword=%s}", ClassUtils.getShortClassName(this.getClass()), this.trustStoreFile.getAbsolutePath(), "****");
    }
}

