/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.maven.AbstractMavenDeployableProjectModelBuilder;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MavenDeployableProjectModelBuilder
extends AbstractMavenDeployableProjectModelBuilder {
    private static final String DEFAULT_PACKAGE_EXPORT = "";
    private static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String CLASS_PATH_SEPARATOR = "/";
    private static final String DEFAULT_SOURCES_DIRECTORY = "src/main";
    private static final String DEFAULT_SOURCES_JAVA_DIRECTORY = "/java";
    private static final String DEFAULT_RESOURCES_DIRECTORY = "/resources";
    private static final String DEFAULT_MULE_DIRECTORY = "/mule";
    private static final String DEFAULT_TEST_RESOURCES_DIRECTORY = "/test/resources";
    private final List<Path> resourcesPath = new ArrayList<Path>();
    private final boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor;
    private final boolean includeTestDependencies;

    public MavenDeployableProjectModelBuilder(File projectFolder, MavenConfiguration mavenConfiguration, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, boolean includeTestDependencies) {
        super(mavenConfiguration, projectFolder);
        this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor = exportAllResourcesAndPackagesIfEmptyLoaderDescriptor;
        this.includeTestDependencies = includeTestDependencies;
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration(), exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, false);
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, boolean includeTestDependencies) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration(), exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, includeTestDependencies);
    }

    public MavenDeployableProjectModelBuilder(File projectFolder) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration(), false, false);
    }

    protected static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    @Override
    protected DeployableProjectModel doBuild(Model pomModel, ArtifactCoordinates deployableArtifactCoordinates) {
        try {
            List<String> packages = this.getAvailablePackages(pomModel.getBuild());
            List<String> resources = this.getAvailableResources(pomModel.getBuild());
            return new DeployableProjectModel(packages, resources, this.resourcesPath, this.buildBundleDescriptor(deployableArtifactCoordinates), this.getDeployableModelResolver(deployableArtifactCoordinates, resources, packages), this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
        }
        catch (IOException e) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)"Couldn't search exported packages and resources"), e);
        }
    }

    private Supplier<MuleDeployableModel> getDeployableModelResolver(ArtifactCoordinates deployableArtifactCoordinates, List<String> resources, List<String> packages) {
        if (deployableArtifactCoordinates.getClassifier().equals("mule-application")) {
            return () -> {
                MuleApplicationModel applicationModel = ArtifactModelResolver.applicationModelResolver().resolve(this.projectFolder);
                if (this.shouldEditApplicationModel(applicationModel)) {
                    applicationModel = this.buildApplicationModel(applicationModel, resources, packages);
                }
                return applicationModel;
            };
        }
        if (deployableArtifactCoordinates.getClassifier().equals("mule-domain")) {
            return () -> ArtifactModelResolver.domainModelResolver().resolve(this.projectFolder);
        }
        throw new IllegalStateException("project is not a mule-application or mule-domain");
    }

    private boolean shouldEditApplicationModel(MuleApplicationModel applicationModel) {
        return this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor && applicationModel.getClassLoaderModelLoaderDescriptor() == null || this.includeTestDependencies;
    }

    @Override
    protected boolean isIncludeTestDependencies() {
        return this.includeTestDependencies;
    }

    private MuleApplicationModel buildApplicationModel(MuleApplicationModel applicationModel, List<String> resources, List<String> packages) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = ((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)new MuleApplicationModel.MuleApplicationModelBuilder().setName(applicationModel.getName() != null ? applicationModel.getName() : "mule")).setMinMuleVersion(applicationModel.getMinMuleVersion())).setRequiredProduct(applicationModel.getRequiredProduct())).withClassLoaderModelDescriptorLoader(this.createClassLoaderModelDescriptorLoader(applicationModel.getClassLoaderModelLoaderDescriptor(), resources, packages))).withBundleDescriptorLoader(applicationModel.getBundleDescriptorLoader() != null ? applicationModel.getBundleDescriptorLoader() : new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).setDomain((String)applicationModel.getDomain().orElse(null));
        if (!this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor || applicationModel.getClassLoaderModelLoaderDescriptor() == null) {
            // empty if block
        }
        builder.setConfigs(applicationModel.getConfigs());
        builder.setRedeploymentEnabled(applicationModel.isRedeploymentEnabled());
        builder.setSecureProperties(applicationModel.getSecureProperties());
        builder.setLogConfigFile(applicationModel.getLogConfigFile());
        return (MuleApplicationModel)builder.build();
    }

    private MuleArtifactLoaderDescriptor createClassLoaderModelDescriptorLoader(MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, List<String> resources, List<String> packages) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor && classLoaderModelLoaderDescriptor == null) {
            attributes.put("exportedResources", resources);
            attributes.put("exportedPackages", packages);
        }
        if (this.isIncludeTestDependencies()) {
            attributes.put("includeTestDependencies", "true");
        }
        return new MuleArtifactLoaderDescriptor("mule", attributes);
    }

    private List<String> getAvailablePackages(Build build) throws IOException {
        String sourceDirectory = build.getSourceDirectory() != null ? build.getSourceDirectory() : DEFAULT_SOURCES_DIRECTORY;
        Path javaDirectory = Paths.get(this.projectFolder.getAbsolutePath(), sourceDirectory.concat(DEFAULT_SOURCES_JAVA_DIRECTORY));
        if (!javaDirectory.toFile().exists()) {
            return Collections.emptyList();
        }
        List allJavaFiles = Files.walk(javaDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        Predicate<Path> isJavaFile = path -> FilenameUtils.getExtension((String)path.toString()).endsWith(JAVA_EXTENSION);
        return allJavaFiles.stream().filter(isJavaFile).map(path -> {
            Path parent = javaDirectory.relativize((Path)path).getParent();
            return parent != null ? parent.toString() : DEFAULT_PACKAGE_EXPORT;
        }).map(this::escapeSlashes).map(s -> s.replace(CLASS_PATH_SEPARATOR, PACKAGE_SEPARATOR)).distinct().collect(Collectors.toList());
    }

    private List<String> getAvailableResources(Build build) throws IOException {
        String sourceDirectory = build.getSourceDirectory() != null ? build.getSourceDirectory() : DEFAULT_SOURCES_DIRECTORY;
        List<String> resources = this.getResourcesInFolder(sourceDirectory.concat(DEFAULT_MULE_DIRECTORY));
        if (resources.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)(sourceDirectory.concat(DEFAULT_MULE_DIRECTORY) + " cannot be empty")));
        }
        if (this.isIncludeTestDependencies()) {
            resources.addAll(this.getResourcesInFolder(sourceDirectory.concat(DEFAULT_TEST_RESOURCES_DIRECTORY)));
        }
        if (build.getResources().isEmpty()) {
            resources.addAll(this.getResourcesInFolder(sourceDirectory.concat(DEFAULT_RESOURCES_DIRECTORY)));
        } else {
            build.getResources().forEach(r -> {
                try {
                    resources.addAll(this.getResourcesInFolder(r.getDirectory()));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot load files from" + r.getDirectory());
                }
            });
        }
        return resources;
    }

    private List<String> getResourcesInFolder(String resourcesDirectoryName) throws IOException {
        Path resourcesDirectory = Paths.get(this.projectFolder.getAbsolutePath(), resourcesDirectoryName);
        if (!resourcesDirectory.toFile().exists()) {
            return Collections.emptyList();
        }
        this.resourcesPath.add(resourcesDirectory);
        if (Files.notExists(resourcesDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        List allResourcesFiles = Files.walk(resourcesDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        return allResourcesFiles.stream().map(resourcesDirectory::relativize).map(Path::toString).map(this::escapeSlashes).collect(Collectors.toList());
    }

    private String escapeSlashes(String p) {
        return p.replace("\\", CLASS_PATH_SEPARATOR);
    }

    @Override
    protected File getPomFromFolder(File projectFolder) {
        String pomFilePath = "pom.xml";
        File pomFile = new File(projectFolder, pomFilePath);
        Preconditions.checkState((boolean)pomFile.exists(), (String)String.format("The pom.xml file for artifact in folder %s could not be found", projectFolder.getAbsolutePath()));
        return pomFile;
    }
}

