/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.StreamFactory;
import com.esotericsoftware.kryo.util.DefaultStreamFactory;
import com.esotericsoftware.kryo.util.MapReferenceResolver;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.util.FunctionalUtils;
import org.mule.runtime.api.util.Preconditions;

final class ExternalizableKryo
extends Kryo {
    private Class<?> classBeingRegistered = null;
    private final Map<Class, Registration> class2Registration = new HashMap<Class, Registration>();

    public ExternalizableKryo(ClassResolver classResolver) {
        super(classResolver, (ReferenceResolver)new MapReferenceResolver(), (StreamFactory)new DefaultStreamFactory());
    }

    public Registration register(Class type, Serializer serializer) {
        this.classBeingRegistered = type;
        try {
            Registration registration = super.register(type, serializer);
            return registration;
        }
        finally {
            this.classBeingRegistered = null;
        }
    }

    public int getNextRegistrationId() {
        Preconditions.checkState((this.classBeingRegistered != null ? 1 : 0) != 0, (String)"Cannot generate an id while no class is being registered");
        return this.classBeingRegistered.getCanonicalName().hashCode();
    }

    protected Class<?> getClassBeingRegistered() {
        return this.classBeingRegistered;
    }

    public Registration getRegistration(Class type) {
        return (Registration)FunctionalUtils.computeIfAbsent(this.class2Registration, (Object)type, c -> {
            Registration registration = null;
            Class searchType = type;
            while (registration == null && this.isRecurseRegistrationSearch(searchType)) {
                registration = super.getRegistration(searchType);
                if (registration.getId() == -1) {
                    registration = null;
                }
                searchType = searchType.getSuperclass();
            }
            if (registration == null) {
                Class<?>[] classArray = type.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> iFace = classArray[n2];
                    registration = this.getRegistration(iFace);
                    if (registration.getId() != -1) break;
                    registration = null;
                    ++n2;
                }
            }
            return registration != null ? registration : super.getRegistration(type);
        });
    }

    private <T> boolean isRecurseRegistrationSearch(Class<T> searchType) {
        return searchType != null && !Enum.class.isAssignableFrom(searchType) && !Object.class.equals(searchType);
    }
}

