/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransactionalDelegateSink
implements Sink,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDelegateSink.class);
    private final Sink transactionalSink;
    private final Sink sink;

    public TransactionalDelegateSink(Sink transactionalSink, Sink sink) {
        this.transactionalSink = transactionalSink;
        this.sink = sink;
    }

    @Override
    public void accept(CoreEvent event) {
        if (TransactionCoordination.isTransactionActive()) {
            this.transactionalSink.accept(event);
        } else {
            this.sink.accept(event);
        }
    }

    @Override
    public BackPressureReason emit(CoreEvent event) {
        if (TransactionCoordination.isTransactionActive()) {
            return this.transactionalSink.emit(event);
        }
        return this.sink.emit(event);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.transactionalSink, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.sink, LOGGER);
    }
}

