/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.RejectedExecutionException;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.reactivestreams.Publisher;

public abstract class ProcessingStrategyDecorator
implements ProcessingStrategy,
Lifecycle {
    protected final ProcessingStrategy delegate;
    @Inject
    private MuleContext muleContext;

    public ProcessingStrategyDecorator(ProcessingStrategy delegate) {
        this.delegate = delegate;
    }

    @Override
    public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
        return this.delegate.createSink(flowConstruct, pipeline);
    }

    @Override
    public void registerInternalSink(Publisher<CoreEvent> publisher, String sinkRepresentation) {
        this.delegate.registerInternalSink(publisher, sinkRepresentation);
    }

    @Override
    public Publisher<CoreEvent> configureInternalPublisher(Publisher<CoreEvent> publisher) {
        return this.delegate.configureInternalPublisher(publisher);
    }

    @Override
    public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
        return this.delegate.onPipeline(pipeline);
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        return this.delegate.onProcessor(processor);
    }

    @Override
    public boolean isSynchronous() {
        return this.delegate.isSynchronous();
    }

    @Override
    public void checkBackpressureAccepting(CoreEvent event) throws RejectedExecutionException {
        this.delegate.checkBackpressureAccepting(event);
    }

    @Override
    public BackPressureReason checkBackpressureEmitting(CoreEvent event) {
        return this.delegate.checkBackpressureEmitting(event);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    public void dispose() {
        if (this.delegate instanceof Disposable) {
            ((Disposable)this.delegate).dispose();
        }
    }
}

