/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.strategy.ReactorSinkProvider;
import reactor.core.publisher.FluxSink;

public abstract class AbstractCachedThreadReactorSinkProvider
implements ReactorSinkProvider {
    private static final int THREAD_CACHE_TIME_LIMIT_IN_MINUTES = 60;
    private static final int TRANSACTION_CACHE_TIME_LIMIT_IN_MINUTES = 10;
    private final Cache<Thread, FluxSink<CoreEvent>> sinks = Caffeine.newBuilder().weakKeys().removalListener((thread, coreEventFluxSink, removalCause) -> coreEventFluxSink.complete()).expireAfterAccess(60L, TimeUnit.MINUTES).build();
    private final Cache<Transaction, FluxSink<CoreEvent>> sinksNestedTx = Caffeine.newBuilder().weakKeys().removalListener((transaction, coreEventFluxSink, removalCause) -> coreEventFluxSink.complete()).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public void dispose() {
        this.sinks.asMap().values().forEach(FluxSink::complete);
        this.sinksNestedTx.asMap().values().forEach(FluxSink::complete);
    }

    protected void invalidateAll() {
        this.sinks.invalidateAll();
        this.sinksNestedTx.invalidateAll();
    }

    @Override
    public FluxSink<CoreEvent> getSink() {
        TransactionCoordination txCoord = TransactionCoordination.getInstance();
        if (txCoord.runningNestedTransaction()) {
            return (FluxSink)this.sinksNestedTx.get((Object)txCoord.getTransaction(), tx -> this.createSink());
        }
        return (FluxSink)this.sinks.get((Object)Thread.currentThread(), t -> this.createSink());
    }

    protected abstract FluxSink<CoreEvent> createSink();
}

