/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.Collection;
import java.util.Optional;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;

public final class SourceErrorException
extends MuleRuntimeException {
    private static final long serialVersionUID = 160215774280116878L;
    private final CoreEvent event;
    private final ErrorType errorType;
    private final MessagingException originalCause;

    public SourceErrorException(CoreEvent event, ErrorType errorType, Throwable cause) {
        super(cause);
        this.event = event;
        this.errorType = errorType;
        this.originalCause = null;
    }

    public SourceErrorException(CoreEvent event, ErrorType errorType, Throwable cause, MessagingException originalCause) {
        super(cause);
        this.event = event;
        this.errorType = errorType;
        this.originalCause = originalCause;
    }

    public CoreEvent getEvent() {
        return this.event;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<MessagingException> getOriginalCause() {
        return Optional.ofNullable(this.originalCause);
    }

    public MessagingException toMessagingException(Collection<ExceptionContextProvider> exceptionContextProviders, MessageSource messageSource) {
        MessagingException messagingException = new MessagingException(CoreEvent.builder(this.getEvent()).error(ErrorBuilder.builder(this.getCause()).errorType(this.getErrorType()).build()).build(), this.getCause());
        EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo((Event)messagingException.getEvent(), (Exception)((Object)messagingException), null);
        for (ExceptionContextProvider exceptionContextProvider : exceptionContextProviders) {
            exceptionContextProvider.putContextInfo(messagingException.getExceptionInfo(), notificationInfo, messageSource);
        }
        return messagingException;
    }
}

