/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PoolingConnectionHandler<C>
implements ConnectionHandlerAdapter<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingConnectionHandler.class);
    private C connection;
    private final GenericObjectPool<C> pool;
    private final String poolId;
    private final PoolingListener poolingListener;
    private final ConnectionProvider connectionProvider;
    private final AtomicBoolean released = new AtomicBoolean(false);

    PoolingConnectionHandler(C connection, GenericObjectPool<C> pool, String poolId, PoolingListener poolingListener, ConnectionProvider connectionProvider) {
        this.connection = connection;
        this.pool = pool;
        this.poolId = poolId;
        this.poolingListener = poolingListener;
        this.connectionProvider = connectionProvider;
    }

    public C getConnection() throws ConnectionException {
        Preconditions.checkState((this.connection != null ? 1 : 0) != 0, (String)"Connection has been either released or invalidated");
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.connection == null || this.released.getAndSet(true)) {
            return;
        }
        boolean returnAttempted = false;
        try {
            LOGGER.debug("Returning back connection {} to pool {}", (Object)this.connection.toString(), (Object)this.poolId);
            this.poolingListener.onReturn(this.connection);
            this.pool.returnObject(this.connection);
            ConnectionUtils.logPoolStatus(LOGGER, this.pool, this.poolId);
            returnAttempted = true;
        }
        catch (Exception e) {
            LOGGER.warn("Could not return connection to the pool. Connection will be terminated", (Throwable)e);
        }
        finally {
            try {
                if (!returnAttempted) {
                    this.invalidate();
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void invalidate() {
        try {
            LOGGER.debug("Invalidating connection {} from pool {}", (Object)this.connection.toString(), (Object)this.poolId);
            this.pool.invalidateObject(this.connection);
            ConnectionUtils.logPoolStatus(LOGGER, this.pool, this.poolId);
        }
        catch (Exception e) {
            LOGGER.warn("Exception was thrown trying to invalidate connection of type " + this.connection.getClass().getName(), (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public void close() throws MuleException {
    }
}

