/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.traversers;

import java.util.HashMap;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.StaticNameResolver;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.xpath.XPath20;
import org.mule.apache.xerces.impl.xpath.XPathException;
import org.mule.apache.xerces.impl.xs.AbstractPsychoPathXPath2Impl;
import org.mule.apache.xerces.impl.xs.SchemaGrammar;
import org.mule.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.XSAnnotationImpl;
import org.mule.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.mule.apache.xerces.impl.xs.XSElementDecl;
import org.mule.apache.xerces.impl.xs.alternative.Test;
import org.mule.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.mule.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.mule.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.mule.apache.xerces.impl.xs.traversers.XSDHandler;
import org.mule.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.mule.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.mule.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.mule.apache.xerces.util.DOMUtil;
import org.mule.apache.xerces.util.NamespaceSupport;
import org.mule.apache.xerces.util.XMLSymbols;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Element;

class XSDTypeAlternativeTraverser
extends XSDAbstractTraverser {
    private static final XSSimpleType fErrorType;
    private boolean fIsFullXPathModeForCTA;
    private String[] fctaXPathModes = new String[]{"cta-subset", "cta-full"};

    XSDTypeAlternativeTraverser(XSDHandler handler, XSAttributeChecker attrChecker) {
        super(handler, attrChecker);
        this.fIsFullXPathModeForCTA = handler.fFullXPathForCTA;
    }

    public void traverse(Element altElement, XSElementDecl element, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(altElement, false, schemaDoc);
        QName typeAtt = (QName)attrValues[XSAttributeChecker.ATTIDX_TYPE];
        String testStr = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH];
        String xpathDefaultNS = (String)attrValues[XSAttributeChecker.ATTIDX_XPATHDEFAULTNS];
        Element childNode = DOMUtil.getFirstChildElement(altElement);
        XSAnnotationImpl annotation = null;
        if (childNode != null && DOMUtil.getLocalName(childNode).equals(SchemaSymbols.ELT_ANNOTATION)) {
            annotation = this.traverseAnnotationDecl(childNode, attrValues, false, schemaDoc);
            childNode = DOMUtil.getNextSiblingElement(childNode);
        } else {
            String text = DOMUtil.getSyntheticAnnotation(altElement);
            if (text != null) {
                annotation = this.traverseSyntheticAnnotation(altElement, text, attrValues, false, schemaDoc);
            }
        }
        XSObjectListImpl annotations = null;
        if (annotation != null) {
            annotations = new XSObjectListImpl();
            annotations.addXSObject(annotation);
        } else {
            annotations = XSObjectListImpl.EMPTY_LIST;
        }
        XSTypeDefinition alternativeType = null;
        boolean hasAnonType = false;
        if (typeAtt != null) {
            alternativeType = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, typeAtt, altElement);
        }
        if (childNode != null) {
            String childName = DOMUtil.getLocalName(childNode);
            XSTypeDefinition typeDef = null;
            if (childName.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                typeDef = this.fSchemaHandler.fComplexTypeTraverser.traverseLocal(childNode, schemaDoc, grammar, element);
                hasAnonType = true;
                childNode = DOMUtil.getNextSiblingElement(childNode);
            } else if (childName.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                typeDef = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(childNode, schemaDoc, grammar, element);
                hasAnonType = true;
                childNode = DOMUtil.getNextSiblingElement(childNode);
            }
            if (alternativeType == null) {
                alternativeType = typeDef;
            }
            if (hasAnonType && typeAtt != null) {
                this.reportSchemaError("src-type-alternative.3.12.13.1", null, altElement);
            }
        }
        if (typeAtt == null && !hasAnonType) {
            this.reportSchemaError("src-type-alternative.3.12.13.2", null, altElement);
        }
        if (alternativeType == null) {
            alternativeType = element.fType;
        } else if (alternativeType != fErrorType) {
            short block = element.fBlock;
            if (element.fType.getTypeCategory() == 15) {
                block = (short)(block | ((XSComplexTypeDecl)element.fType).getProhibitedSubstitutions());
            }
            if (!this.fSchemaHandler.fXSConstraints.checkTypeDerivationOk(alternativeType, element.fType, block)) {
                this.reportSchemaError("e-props-correct.7", new Object[]{element.getName(), XS11TypeHelper.getSchemaTypeName(alternativeType), XS11TypeHelper.getSchemaTypeName(element.fType)}, altElement);
                alternativeType = element.fType;
            }
        }
        if (childNode != null) {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"type alternative", "(annotation?, (simpleType | complexType)?)", DOMUtil.getLocalName(childNode)}, childNode);
        }
        XSTypeAlternativeImpl typeAlternative = new XSTypeAlternativeImpl(element.fName, alternativeType, annotations);
        if (testStr != null) {
            Test testExpr = null;
            try {
                if (this.fIsFullXPathModeForCTA) {
                    JFlexCupParser xpp = new JFlexCupParser();
                    XPath xp = xpp.parse("boolean(" + testStr + ")", true);
                    HashMap<String, SchemaNamespaceSupport> psychoPathParams = new HashMap<String, SchemaNamespaceSupport>();
                    psychoPathParams.put("XPATH2_NS_CONTEXT", schemaDoc.fNamespaceSupport);
                    AbstractPsychoPathXPath2Impl abstractPsychoPathInst = new AbstractPsychoPathXPath2Impl();
                    StaticNameResolver name_check = new StaticNameResolver((StaticContext)abstractPsychoPathInst.initXPath2DynamicContext(null, null, psychoPathParams));
                    name_check.check((XPathNode)xp);
                    testExpr = new Test(xp, testStr, typeAlternative, schemaDoc.fNamespaceSupport);
                } else {
                    testExpr = new Test(new XPath20(testStr, this.fSymbolTable, new NamespaceSupport(schemaDoc.fNamespaceSupport)), typeAlternative, new NamespaceSupport(schemaDoc.fNamespaceSupport));
                }
            }
            catch (XPathException e) {
                testExpr = new Test(null, typeAlternative, new NamespaceSupport(schemaDoc.fNamespaceSupport));
                this.reportSchemaError("c-cta-xpath", new Object[]{testStr, this.fctaXPathModes[0]}, altElement);
            }
            catch (XPathParserException ex) {
                testExpr = new Test(null, typeAlternative, new NamespaceSupport(schemaDoc.fNamespaceSupport));
                if ("Expression starts with / or //".equals(ex.getMessage())) {
                    this.fSchemaHandler.reportSchemaWarning("c-cta-xpath-b", new Object[]{testStr, this.fctaXPathModes[1]}, altElement);
                } else {
                    this.reportSchemaError("c-cta-xpath", new Object[]{testStr, this.fctaXPathModes[1]}, altElement);
                }
            }
            catch (StaticError serr) {
                testExpr = new Test(null, typeAlternative, new NamespaceSupport(schemaDoc.fNamespaceSupport));
                this.reportSchemaError("c-cta-xpath-serr", new Object[]{testStr, this.fctaXPathModes[1], serr.code()}, altElement);
            }
            typeAlternative.setTest(testExpr);
        } else {
            typeAlternative.setNamespaceContext(new NamespaceSupport(schemaDoc.fNamespaceSupport));
        }
        String baseURI = this.fSchemaHandler.getDocumentURI(altElement);
        if (baseURI != null) {
            typeAlternative.setBaseURI(baseURI);
        }
        if (xpathDefaultNS == null) {
            if (schemaDoc.fXpathDefaultNamespaceIs2PoundDefault) {
                xpathDefaultNS = schemaDoc.fValidationContext.getURI(XMLSymbols.EMPTY_STRING);
                if (xpathDefaultNS != null) {
                    xpathDefaultNS = this.fSymbolTable.addSymbol(xpathDefaultNS);
                }
            } else {
                xpathDefaultNS = schemaDoc.fXpathDefaultNamespace;
            }
        }
        if (xpathDefaultNS != null) {
            typeAlternative.setXPathDefauleNamespace(xpathDefaultNS);
        }
        grammar.addTypeAlternative(element, typeAlternative);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }

    static {
        SchemaGrammar grammar = SchemaGrammar.getS4SGrammar((short)4);
        fErrorType = (XSSimpleType)grammar.getGlobalTypeDecl("error");
    }
}

