/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Stack;
import org.mule.apache.xerces.impl.XMLErrorReporter;
import org.mule.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.mule.apache.xerces.impl.dv.ValidatedInfo;
import org.mule.apache.xerces.impl.dv.ValidationContext;
import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.xs.SchemaGrammar;
import org.mule.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.mule.apache.xerces.impl.xs.XMLSchemaException;
import org.mule.apache.xerces.impl.xs.XS10Constraints;
import org.mule.apache.xerces.impl.xs.XS11Constraints;
import org.mule.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.mule.apache.xerces.impl.xs.XSElementDecl;
import org.mule.apache.xerces.impl.xs.XSGrammarBucket;
import org.mule.apache.xerces.impl.xs.XSGroupDecl;
import org.mule.apache.xerces.impl.xs.XSModelGroupImpl;
import org.mule.apache.xerces.impl.xs.XSParticleDecl;
import org.mule.apache.xerces.impl.xs.XSWildcardDecl;
import org.mule.apache.xerces.impl.xs.models.CMBuilder;
import org.mule.apache.xerces.impl.xs.models.XSCMValidator;
import org.mule.apache.xerces.impl.xs.util.SimpleLocator;
import org.mule.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.mule.apache.xerces.util.SymbolHash;
import org.mule.apache.xerces.xs.XSObjectList;
import org.mule.apache.xerces.xs.XSTypeDefinition;

public abstract class XSConstraints {
    static final int OCCURRENCE_UNKNOWN = -2;
    static final XSSimpleType STRING_TYPE = (XSSimpleType)SchemaGrammar.getS4SGrammar((short)1).getGlobalTypeDecl("string");
    private static XSParticleDecl fEmptyParticle = null;
    static final XSConstraints XS_1_0_CONSTRAINTS = new XS10Constraints(1);
    static final XSConstraints XS_1_0_CONSTRAINTS_EXTENDED = new XS10Constraints(2);
    static final XSConstraints XS_1_1_CONSTRAINTS = new XS11Constraints();
    private final XSComplexTypeDecl fAnyType;
    protected final short fSchemaVersion;

    public static XSParticleDecl getEmptySequence() {
        if (fEmptyParticle == null) {
            XSModelGroupImpl group = new XSModelGroupImpl();
            group.fCompositor = (short)102;
            group.fParticleCount = 0;
            group.fParticles = null;
            group.fAnnotations = XSObjectListImpl.EMPTY_LIST;
            XSParticleDecl particle = new XSParticleDecl();
            particle.fType = (short)3;
            particle.fValue = group;
            particle.fAnnotations = XSObjectListImpl.EMPTY_LIST;
            fEmptyParticle = particle;
        }
        return fEmptyParticle;
    }

    protected XSConstraints(XSComplexTypeDecl anyType, short schemaVersion) {
        this.fAnyType = anyType;
        this.fSchemaVersion = schemaVersion;
    }

    public final short getSchemaVersion() {
        return this.fSchemaVersion;
    }

    public boolean isTypeTablesEquivalent(XSElementDecl elementDecl1, XSElementDecl elementDecl2) {
        return true;
    }

    public boolean checkTypeDerivationOk(XSTypeDefinition derived, XSTypeDefinition base, short block) {
        if (derived == this.fAnyType) {
            return derived == base;
        }
        if (derived == SchemaGrammar.fAnySimpleType) {
            return base == this.fAnyType || base == SchemaGrammar.fAnySimpleType;
        }
        if (derived.getTypeCategory() == 16) {
            if (base.getTypeCategory() == 15) {
                if (base == this.fAnyType) {
                    base = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return this.checkSimpleDerivation((XSSimpleType)derived, (XSSimpleType)base, block);
        }
        return this.checkComplexDerivation((XSComplexTypeDecl)derived, base, block);
    }

    public boolean checkSimpleDerivationOk(XSSimpleType derived, XSTypeDefinition base, short block) {
        if (derived == SchemaGrammar.fAnySimpleType) {
            return base == this.fAnyType || base == SchemaGrammar.fAnySimpleType;
        }
        if (base.getTypeCategory() == 15) {
            if (base == this.fAnyType) {
                base = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return this.checkSimpleDerivation(derived, (XSSimpleType)base, block);
    }

    public boolean checkComplexDerivationOk(XSComplexTypeDecl derived, XSTypeDefinition base, short block) {
        if (derived == this.fAnyType) {
            return derived == base;
        }
        return this.checkComplexDerivation(derived, base, block);
    }

    private boolean checkSimpleDerivation(XSSimpleType derived, XSSimpleType base, short block) {
        if (derived == base) {
            return true;
        }
        if ((block & 2) != 0 || (derived.getBaseType().getFinal() & 2) != 0) {
            return false;
        }
        XSSimpleType directBase = (XSSimpleType)derived.getBaseType();
        if (directBase == base) {
            return true;
        }
        if (directBase != SchemaGrammar.fAnySimpleType && this.checkSimpleDerivation(directBase, base, block)) {
            return true;
        }
        if ((derived.getVariety() == 2 || derived.getVariety() == 3) && base == SchemaGrammar.fAnySimpleType) {
            return true;
        }
        if (base.getVariety() == 3 && this.checkEmptyFacets(base)) {
            XSObjectList subUnionMemberDV = base.getMemberTypes();
            int subUnionSize = subUnionMemberDV.getLength();
            for (int i = 0; i < subUnionSize; ++i) {
                base = (XSSimpleType)subUnionMemberDV.item(i);
                if (!this.checkSimpleDerivation(derived, base, block)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkComplexDerivation(XSComplexTypeDecl derived, XSTypeDefinition base, short block) {
        if (derived == base) {
            return true;
        }
        if ((derived.fDerivedBy & block) != 0) {
            return false;
        }
        XSTypeDefinition directBase = derived.fBaseType;
        if (directBase == base) {
            return true;
        }
        if (directBase == this.fAnyType || directBase == SchemaGrammar.fAnySimpleType) {
            return false;
        }
        if (directBase.getTypeCategory() == 15) {
            return this.checkComplexDerivation((XSComplexTypeDecl)directBase, base, block);
        }
        if (directBase.getTypeCategory() == 16) {
            if (base.getTypeCategory() == 15) {
                if (base == this.fAnyType) {
                    base = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return this.checkSimpleDerivation((XSSimpleType)directBase, (XSSimpleType)base, block);
        }
        return false;
    }

    public Object ElementDefaultValidImmediate(XSTypeDefinition type, String value, ValidationContext context, ValidatedInfo vinfo) {
        XSSimpleType dv = null;
        if (type.getTypeCategory() == 16) {
            dv = (XSSimpleType)type;
        } else {
            XSComplexTypeDecl ctype = (XSComplexTypeDecl)type;
            if (ctype.fContentType == 1) {
                dv = ctype.fXSSimpleType;
            } else if (ctype.fContentType == 3) {
                if (!((XSParticleDecl)ctype.getParticle()).emptiable()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        Object actualValue = null;
        if (dv == null) {
            dv = STRING_TYPE;
        }
        try {
            actualValue = dv.validate(value, context, vinfo);
            if (vinfo != null) {
                actualValue = dv.validate(vinfo.stringValue(), context, vinfo);
            }
        }
        catch (InvalidDatatypeValueException ide) {
            return null;
        }
        return actualValue;
    }

    void reportSchemaError(XMLErrorReporter errorReporter, SimpleLocator loc, String key, Object[] args) {
        if (loc != null) {
            errorReporter.reportError(loc, "http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
        } else {
            errorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
        }
    }

    public void fullSchemaChecking(XSGrammarBucket grammarBucket, SubstitutionGroupHandler SGHandler, CMBuilder cmBuilder, XMLErrorReporter errorReporter) {
        SchemaGrammar[] grammars = grammarBucket.getGrammars();
        for (int i = grammars.length - 1; i >= 0; --i) {
            SGHandler.addSubstitutionGroup(grammars[i].getSubstitutionGroups());
        }
        XSParticleDecl fakeDerived = new XSParticleDecl();
        XSParticleDecl fakeBase = new XSParticleDecl();
        fakeDerived.fType = (short)3;
        fakeBase.fType = (short)3;
        for (int g = grammars.length - 1; g >= 0; --g) {
            XSGroupDecl[] redefinedGroups = grammars[g].getRedefinedGroupDecls();
            SimpleLocator[] rgLocators = grammars[g].getRGLocators();
            int i = 0;
            while (i < redefinedGroups.length) {
                XSGroupDecl derivedGrp = redefinedGroups[i++];
                XSModelGroupImpl derivedMG = derivedGrp.fModelGroup;
                XSGroupDecl baseGrp = redefinedGroups[i++];
                XSModelGroupImpl baseMG = baseGrp.fModelGroup;
                fakeDerived.fValue = derivedMG;
                fakeBase.fValue = baseMG;
                if (baseMG == null) {
                    if (derivedMG == null) continue;
                    this.reportSchemaError(errorReporter, rgLocators[i / 2 - 1], "src-redefine.6.2.2", new Object[]{derivedGrp.fName, "rcase-Recurse.2"});
                    continue;
                }
                if (derivedMG == null) {
                    if (fakeBase.emptiable()) continue;
                    this.reportSchemaError(errorReporter, rgLocators[i / 2 - 1], "src-redefine.6.2.2", new Object[]{derivedGrp.fName, "rcase-Recurse.2"});
                    continue;
                }
                this.groupSubsumption(fakeDerived, fakeBase, grammarBucket, SGHandler, cmBuilder, errorReporter, derivedGrp.fName, rgLocators[i / 2 - 1]);
            }
        }
        SymbolHash elemTable = new SymbolHash();
        Stack stack = new Stack();
        ArrayList wcList = this.fSchemaVersion == 4 ? new ArrayList() : null;
        for (int i = grammars.length - 1; i >= 0; --i) {
            int keepType = 0;
            boolean fullChecked = grammars[i].fFullChecked;
            XSComplexTypeDecl[] types = grammars[i].getUncheckedComplexTypeDecls();
            SimpleLocator[] ctLocators = grammars[i].getUncheckedCTLocators();
            for (int j = 0; j < types.length; ++j) {
                if (!fullChecked && types[j].fParticle != null) {
                    elemTable.clear();
                    try {
                        this.checkElementDeclsConsistent(types[j], types[j].fParticle, elemTable, SGHandler, grammarBucket, wcList, stack);
                    }
                    catch (XMLSchemaException e) {
                        this.reportSchemaError(errorReporter, ctLocators[j], e.getKey(), e.getArgs());
                    }
                }
                if (types[j].fBaseType != null && types[j].fBaseType != this.fAnyType && types[j].fDerivedBy == 2 && types[j].fBaseType instanceof XSComplexTypeDecl) {
                    XSParticleDecl derivedParticle = types[j].fParticle;
                    XSComplexTypeDecl bType = (XSComplexTypeDecl)types[j].fBaseType;
                    XSParticleDecl baseParticle = bType.fParticle;
                    if (derivedParticle == null) {
                        if (baseParticle != null && !baseParticle.emptiable()) {
                            this.reportSchemaError(errorReporter, ctLocators[j], "derivation-ok-restriction.5.3.2", new Object[]{types[j].fName, types[j].fBaseType.getName()});
                        }
                    } else if (baseParticle != null) {
                        this.typeSubsumption(types[j], bType, grammarBucket, SGHandler, cmBuilder, errorReporter, ctLocators[j]);
                    } else {
                        this.reportSchemaError(errorReporter, ctLocators[j], "derivation-ok-restriction.5.4.2", new Object[]{types[j].fName});
                    }
                }
                XSCMValidator cm = types[j].getContentModel(cmBuilder, true);
                boolean further = false;
                if (cm != null) {
                    try {
                        further = cm.checkUniqueParticleAttribution(SGHandler, this);
                    }
                    catch (XMLSchemaException e) {
                        this.reportSchemaError(errorReporter, ctLocators[j], e.getKey(), e.getArgs());
                    }
                }
                if (fullChecked || !further) continue;
                types[keepType++] = types[j];
            }
            if (fullChecked) continue;
            grammars[i].setUncheckedTypeNum(keepType);
            grammars[i].fFullChecked = true;
        }
    }

    public void checkElementDeclsConsistent(XSComplexTypeDecl type, XSParticleDecl particle, SymbolHash elemDeclHash, SubstitutionGroupHandler sgHandler) throws XMLSchemaException {
        short pType = particle.fType;
        if (pType == 2) {
            return;
        }
        if (pType == 1) {
            XSElementDecl elem = (XSElementDecl)particle.fValue;
            this.findElemInTable(type, elem, elemDeclHash);
            if (elem.fScope == 1) {
                XSElementDecl[] subGroup = sgHandler.getSubstitutionGroup(elem, this.fSchemaVersion);
                for (int i = 0; i < subGroup.length; ++i) {
                    this.findElemInTable(type, subGroup[i], elemDeclHash);
                }
            }
            return;
        }
        XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
        for (int i = 0; i < group.fParticleCount; ++i) {
            this.checkElementDeclsConsistent(type, group.fParticles[i], elemDeclHash, sgHandler);
        }
    }

    protected void checkElementDeclsConsistent(XSComplexTypeDecl type, XSParticleDecl particle, SymbolHash elemDeclHash, SubstitutionGroupHandler sgHandler, XSGrammarBucket grammarBucket, ArrayList wcList, Stack stack) throws XMLSchemaException {
        if (stack.size() > 0) {
            stack.clear();
        }
        while (true) {
            short pType;
            if ((pType = particle.fType) != 2) {
                if (pType == 1) {
                    XSElementDecl elem = (XSElementDecl)particle.fValue;
                    this.findElemInTable(type, elem, elemDeclHash);
                    if (elem.fScope == 1) {
                        XSElementDecl[] subGroup = sgHandler.getSubstitutionGroup(elem, this.fSchemaVersion);
                        for (int i = 0; i < subGroup.length; ++i) {
                            this.findElemInTable(type, subGroup[i], elemDeclHash);
                        }
                    }
                } else {
                    XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
                    for (int i = group.fParticleCount - 1; i >= 0; --i) {
                        stack.push(group.fParticles[i]);
                    }
                }
            }
            if (stack.isEmpty()) break;
            particle = (XSParticleDecl)stack.pop();
        }
    }

    public void findElemInTable(XSComplexTypeDecl type, XSElementDecl elem, SymbolHash elemDeclHash) throws XMLSchemaException {
        XSElementDecl existingElem = this.findExistingElement(elem, elemDeclHash);
        if (existingElem == null || existingElem == elem) {
            return;
        }
        if (elem.fType != existingElem.fType) {
            throw new XMLSchemaException("cos-element-consistent", new Object[]{type.fName, elem.fName});
        }
    }

    protected XSElementDecl findExistingElement(XSElementDecl elem, SymbolHash elemDeclHash) {
        String name = elem.fName + "," + elem.fTargetNamespace;
        XSElementDecl existingElem = (XSElementDecl)elemDeclHash.get(name);
        if (existingElem == null) {
            elemDeclHash.put(name, elem);
        }
        return existingElem;
    }

    protected boolean overlapUPA(XSElementDecl element1, XSElementDecl element2, SubstitutionGroupHandler sgHandler) {
        int i;
        if (element1.fName == element2.fName && element1.fTargetNamespace == element2.fTargetNamespace) {
            return true;
        }
        XSElementDecl[] subGroup1 = sgHandler.getSubstitutionGroup(element1, this.fSchemaVersion);
        for (int i2 = subGroup1.length - 1; i2 >= 0; --i2) {
            if (subGroup1[i2].fName != element2.fName || subGroup1[i2].fTargetNamespace != element2.fTargetNamespace) continue;
            return true;
        }
        XSElementDecl[] subGroup2 = sgHandler.getSubstitutionGroup(element2, this.fSchemaVersion);
        for (i = subGroup2.length - 1; i >= 0; --i) {
            if (subGroup2[i].fName != element1.fName || subGroup2[i].fTargetNamespace != element1.fTargetNamespace) continue;
            return true;
        }
        for (i = subGroup1.length - 1; i >= 0; --i) {
            for (int j = subGroup2.length - 1; j >= 0; --j) {
                if (subGroup1[i].fName != subGroup2[j].fName || subGroup1[i].fTargetNamespace != subGroup2[j].fTargetNamespace) continue;
                return true;
            }
        }
        return false;
    }

    public boolean overlapUPA(XSWildcardDecl wildcard1, XSWildcardDecl wildcard2) {
        XSWildcardDecl intersect = this.performIntersectionWith(wildcard1, wildcard2, wildcard1.fProcessContents);
        return intersect == null || intersect.fType != 3 || intersect.fNamespaceList.length != 0;
    }

    public boolean overlapUPA(Object decl1, Object decl2, SubstitutionGroupHandler sgHandler) {
        if (decl1 instanceof XSElementDecl) {
            if (decl2 instanceof XSElementDecl) {
                return this.overlapUPA((XSElementDecl)decl1, (XSElementDecl)decl2, sgHandler);
            }
            return this.overlapUPA((XSElementDecl)decl1, (XSWildcardDecl)decl2, sgHandler);
        }
        if (decl2 instanceof XSElementDecl) {
            return this.overlapUPA((XSElementDecl)decl2, (XSWildcardDecl)decl1, sgHandler);
        }
        return this.overlapUPA((XSWildcardDecl)decl1, (XSWildcardDecl)decl2);
    }

    boolean areSame(XSWildcardDecl wildcard, XSWildcardDecl otherWildcard) {
        if (wildcard.fType == otherWildcard.fType) {
            if (wildcard.fType == 1) {
                return true;
            }
            if (wildcard.fType == 2) {
                return wildcard.fNamespaceList[0] == otherWildcard.fNamespaceList[0];
            }
            if (wildcard.fNamespaceList.length == otherWildcard.fNamespaceList.length) {
                for (int i = 0; i < wildcard.fNamespaceList.length; ++i) {
                    if (this.elementInSet(wildcard.fNamespaceList[i], otherWildcard.fNamespaceList)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    String[] intersect2sets(String[] one, String[] theOther) {
        String[] result = new String[Math.min(one.length, theOther.length)];
        int count = 0;
        for (int i = 0; i < one.length; ++i) {
            if (!this.elementInSet(one[i], theOther)) continue;
            result[count++] = one[i];
        }
        String[] result2 = new String[count];
        System.arraycopy(result, 0, result2, 0, count);
        return result2;
    }

    String[] union2sets(String[] one, String[] theOther) {
        String[] result1 = new String[one.length];
        int count = 0;
        for (int i = 0; i < one.length; ++i) {
            if (this.elementInSet(one[i], theOther)) continue;
            result1[count++] = one[i];
        }
        String[] result2 = new String[count + theOther.length];
        System.arraycopy(result1, 0, result2, 0, count);
        System.arraycopy(theOther, 0, result2, count, theOther.length);
        return result2;
    }

    boolean subset2sets(String[] subSet, String[] superSet) {
        for (int i = 0; i < subSet.length; ++i) {
            if (this.elementInSet(subSet[i], superSet)) continue;
            return false;
        }
        return true;
    }

    boolean elementInSet(String ele, String[] set) {
        boolean found = false;
        for (int i = 0; i < set.length && !found; ++i) {
            if (ele != set[i]) continue;
            found = true;
        }
        return found;
    }

    boolean disjoint2sets(String[] one, String[] theOther) {
        for (int i = 0; i < one.length; ++i) {
            if (!this.elementInSet(one[i], theOther)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isSubsetOf(XSWildcardDecl var1, XSWildcardDecl var2);

    public abstract XSWildcardDecl performUnionWith(XSWildcardDecl var1, XSWildcardDecl var2, short var3);

    public abstract XSWildcardDecl performIntersectionWith(XSWildcardDecl var1, XSWildcardDecl var2, short var3);

    protected abstract boolean checkEmptyFacets(XSSimpleType var1);

    public abstract boolean overlapUPA(XSElementDecl var1, XSWildcardDecl var2, SubstitutionGroupHandler var3);

    protected abstract void groupSubsumption(XSParticleDecl var1, XSParticleDecl var2, XSGrammarBucket var3, SubstitutionGroupHandler var4, CMBuilder var5, XMLErrorReporter var6, String var7, SimpleLocator var8);

    protected abstract void typeSubsumption(XSComplexTypeDecl var1, XSComplexTypeDecl var2, XSGrammarBucket var3, SubstitutionGroupHandler var4, CMBuilder var5, XMLErrorReporter var6, SimpleLocator var7);
}

