/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.construct.ImmutableConstructModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedChainModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedComponentModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedRouteModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.tooling.client.internal.metadata.ToolingCacheIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentModelMediator<T extends ComponentModel, M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentModelMediator.class);
    private ToolingCacheIdGenerator<M> cacheIdGenerator;
    private Map<String, MetadataType> metadataTypesCache;
    private M component;
    private String componentIdentifier;
    private T componentModel;

    public ComponentModelMediator(Map<String, MetadataType> metadataTypesCache, ToolingCacheIdGenerator<M> cacheIdGenerator, M component, String componentIdentifier, T componentModel) {
        this.metadataTypesCache = metadataTypesCache;
        this.cacheIdGenerator = cacheIdGenerator;
        this.component = component;
        this.componentIdentifier = componentIdentifier;
        this.componentModel = componentModel;
    }

    public Optional<T> enrichComponentModel() {
        final Reference filteredModel = new Reference();
        try {
            this.componentModel.accept(new ComponentModelVisitor(){

                public void visit(ConstructModel constructModel) {
                    filteredModel.set((Object)ComponentModelMediator.this.resolveConstructModel(constructModel));
                }

                public void visit(OperationModel operationModel) {
                    filteredModel.set((Object)ComponentModelMediator.this.resolveOperationModel(operationModel));
                }

                public void visit(SourceModel sourceModel) {
                    filteredModel.set((Object)ComponentModelMediator.this.resolveSourceModel(sourceModel));
                }

                public void visit(NestedComponentModel model) {
                }

                public void visit(NestedChainModel model) {
                }

                public void visit(NestedRouteModel model) {
                }
            });
        }
        catch (MissingDynamicMetadataException e) {
            return Optional.empty();
        }
        return Optional.ofNullable(filteredModel.get());
    }

    private List<ParameterGroupModel> resolveParameterGroupModels(List<ParameterGroupModel> parameterGroupModels) {
        return parameterGroupModels.stream().map(parameterGroupModel -> new ImmutableParameterGroupModel(parameterGroupModel.getName(), parameterGroupModel.getDescription(), this.resolveParameterModels(parameterGroupModel.getParameterModels()), parameterGroupModel.getExclusiveParametersModels(), parameterGroupModel.isShowInDsl(), (DisplayModel)parameterGroupModel.getDisplayModel().orElse(null), (LayoutModel)parameterGroupModel.getLayoutModel().orElse(null), parameterGroupModel.getModelProperties())).collect(Collectors.toList());
    }

    private List<ParameterModel> resolveParameterModels(List<ParameterModel> parameterModels) {
        return parameterModels.stream().map(parameterModel -> {
            MetadataType type = parameterModel.getType();
            if (parameterModel.hasDynamicType()) {
                String componentInputMetadataKey = this.cacheIdGenerator.getIdForComponentInputMetadata(this.component, parameterModel.getName()).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s parameter name: %s", this.componentIdentifier, parameterModel.getName())));
                if (!this.metadataTypesCache.containsKey(componentInputMetadataKey)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Dynamic MetadataType for parameter: %s (componentModel: %s) not present in cache", parameterModel.getName(), this.componentIdentifier));
                    }
                    throw new MissingDynamicMetadataException();
                }
                type = this.metadataTypesCache.get(componentInputMetadataKey);
            }
            return new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(), type, parameterModel.hasDynamicType(), parameterModel.isRequired(), parameterModel.isOverrideFromConfig(), parameterModel.isComponentId(), parameterModel.getExpressionSupport(), parameterModel.getDefaultValue(), parameterModel.getRole(), parameterModel.getDslConfiguration(), (DisplayModel)parameterModel.getDisplayModel().orElse(null), (LayoutModel)parameterModel.getLayoutModel().orElse(null), (ValueProviderModel)parameterModel.getValueProviderModel().orElse(null), parameterModel.getAllowedStereotypes(), parameterModel.getModelProperties(), (DeprecationModel)parameterModel.getDeprecationModel().orElse(null));
        }).collect(Collectors.toList());
    }

    private List<? extends NestableElementModel> resolveNestableElementModels(List<? extends NestableElementModel> components) {
        return components.stream().map(this::resolveNestedComponentModel).collect(Collectors.toList());
    }

    private NestableElementModel resolveNestedComponentModel(NestableElementModel nestedModel) {
        NestableElementModelFilterVisitor nestableElementModelVisitor = new NestableElementModelFilterVisitor();
        nestedModel.accept((NestableElementModelVisitor)nestableElementModelVisitor);
        return nestableElementModelVisitor.getNestableElementModelFiltered();
    }

    private ImmutableOperationModel resolveOperationModel(OperationModel operationModel) {
        return new ImmutableOperationModel(operationModel.getName(), operationModel.getDescription(), this.resolveParameterGroupModels(operationModel.getParameterGroupModels()), this.resolveNestableElementModels(operationModel.getNestedComponents()), this.resolveOutputModel(operationModel.getOutput()), this.resolveOutputAttributesModel(operationModel.getOutputAttributes()), operationModel.isBlocking(), operationModel.getExecutionType(), operationModel.requiresConnection(), operationModel.isTransactional(), operationModel.supportsStreaming(), (DisplayModel)operationModel.getDisplayModel().orElse(null), operationModel.getErrorModels(), operationModel.getStereotype(), operationModel.getVisibility(), operationModel.getModelProperties(), operationModel.getNotificationModels(), (DeprecationModel)operationModel.getDeprecationModel().orElse(null));
    }

    private OutputModel resolveOutputModel(OutputModel outputModel) {
        MetadataType type = outputModel.getType();
        if (outputModel.hasDynamicType()) {
            String componentOutputMetadataKey = this.cacheIdGenerator.getIdForComponentOutputMetadata(this.component).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s output", this.componentIdentifier)));
            if (!this.metadataTypesCache.containsKey(componentOutputMetadataKey)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Dynamic output MetadataType for componentModel: %s not present in cache", this.componentIdentifier));
                }
                throw new MissingDynamicMetadataException();
            }
            type = this.metadataTypesCache.get(componentOutputMetadataKey);
        }
        return new ImmutableOutputModel(outputModel.getDescription(), type, outputModel.hasDynamicType(), outputModel.getModelProperties());
    }

    private OutputModel resolveOutputAttributesModel(OutputModel outputModel) {
        MetadataType type = outputModel.getType();
        if (outputModel.hasDynamicType()) {
            String componentAttributesMetadataKey = this.cacheIdGenerator.getIdForComponentAttributesMetadata(this.component).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s output attributes", this.componentIdentifier)));
            if (!this.metadataTypesCache.containsKey(componentAttributesMetadataKey)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Dynamic output attributes MetadataType for componentModel: %s not present in cache", this.componentIdentifier));
                }
                throw new MissingDynamicMetadataException();
            }
            type = this.metadataTypesCache.get(componentAttributesMetadataKey);
        }
        return new ImmutableOutputModel(outputModel.getDescription(), type, outputModel.hasDynamicType(), outputModel.getModelProperties());
    }

    private ImmutableSourceModel resolveSourceModel(SourceModel sourceModel) {
        return new ImmutableSourceModel(sourceModel.getName(), sourceModel.getDescription(), sourceModel.hasResponse(), sourceModel.runsOnPrimaryNodeOnly(), this.resolveParameterGroupModels(sourceModel.getParameterGroupModels()), this.resolveNestableElementModels(sourceModel.getNestedComponents()), this.resolveOutputModel(sourceModel.getOutput()), this.resolveOutputAttributesModel(sourceModel.getOutputAttributes()), sourceModel.getSuccessCallback(), sourceModel.getErrorCallback(), sourceModel.getTerminateCallback(), sourceModel.requiresConnection(), sourceModel.isTransactional(), sourceModel.supportsStreaming(), (DisplayModel)sourceModel.getDisplayModel().orElse(null), sourceModel.getStereotype(), sourceModel.getErrorModels(), sourceModel.getVisibility(), sourceModel.getModelProperties(), sourceModel.getNotificationModels(), (DeprecationModel)sourceModel.getDeprecationModel().orElse(null));
    }

    private ImmutableConstructModel resolveConstructModel(ConstructModel constructModel) {
        return new ImmutableConstructModel(constructModel.getName(), constructModel.getDescription(), this.resolveParameterGroupModels(constructModel.getParameterGroupModels()), this.resolveNestableElementModels(constructModel.getNestedComponents()), constructModel.allowsTopLevelDeclaration(), (DisplayModel)constructModel.getDisplayModel().orElse(null), constructModel.getErrorModels(), constructModel.getStereotype(), constructModel.getVisibility(), constructModel.getModelProperties(), (DeprecationModel)constructModel.getDeprecationModel().orElse(null));
    }

    public static class MissingDynamicMetadataException
    extends RuntimeException {
    }

    private class NestableElementModelFilterVisitor
    implements NestableElementModelVisitor {
        private NestableElementModel nestableElementModel = null;

        private NestableElementModelFilterVisitor() {
        }

        public NestableElementModel getNestableElementModelFiltered() {
            return this.nestableElementModel;
        }

        public void visit(NestedComponentModel nestedComponentModel) {
            this.nestableElementModel = new ImmutableNestedComponentModel(nestedComponentModel.getName(), nestedComponentModel.getDescription(), ComponentModelMediator.this.resolveParameterGroupModels(nestedComponentModel.getParameterGroupModels()), nestedComponentModel.getMinOccurs(), (Integer)nestedComponentModel.getMaxOccurs().orElse(null), nestedComponentModel.getAllowedStereotypes(), ComponentModelMediator.this.resolveNestableElementModels(this.nestableElementModel.getNestedComponents()), (DisplayModel)nestedComponentModel.getDisplayModel().orElse(null), nestedComponentModel.getErrorModels(), nestedComponentModel.getStereotype(), nestedComponentModel.getVisibility(), nestedComponentModel.getModelProperties(), (DeprecationModel)nestedComponentModel.getDeprecationModel().orElse(null), nestedComponentModel.getSemanticTerms());
        }

        public void visit(NestedChainModel nestedChainModel) {
            this.nestableElementModel = new ImmutableNestedChainModel(nestedChainModel.getName(), nestedChainModel.getDescription(), ComponentModelMediator.this.resolveParameterGroupModels(nestedChainModel.getParameterGroupModels()), nestedChainModel.isRequired(), nestedChainModel.getAllowedStereotypes(), ComponentModelMediator.this.resolveNestableElementModels(nestedChainModel.getNestedComponents()), (DisplayModel)nestedChainModel.getDisplayModel().orElse(null), nestedChainModel.getErrorModels(), nestedChainModel.getStereotype(), nestedChainModel.getVisibility(), nestedChainModel.getModelProperties(), (DeprecationModel)nestedChainModel.getDeprecationModel().orElse(null), nestedChainModel.getSemanticTerms());
        }

        public void visit(NestedRouteModel nestedRouteModel) {
            this.nestableElementModel = new ImmutableNestedRouteModel(nestedRouteModel.getName(), nestedRouteModel.getDescription(), ComponentModelMediator.this.resolveParameterGroupModels(nestedRouteModel.getParameterGroupModels()), (DisplayModel)nestedRouteModel.getDisplayModel().orElse(null), nestedRouteModel.getMinOccurs(), (Integer)nestedRouteModel.getMaxOccurs().orElse(null), ComponentModelMediator.this.resolveNestableElementModels(nestedRouteModel.getNestedComponents()), nestedRouteModel.getStereotype(), nestedRouteModel.getVisibility(), nestedRouteModel.getModelProperties(), (DeprecationModel)nestedRouteModel.getDeprecationModel().orElse(null), nestedRouteModel.getSemanticTerms());
        }
    }
}

