/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.deployment.model.api.builder.DeployableArtifactClassLoaderFactoryProvider;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.deployment.model.internal.tooling.ToolingDomainClassLoaderBuilder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public class DomainClassLoaderFactory {
    private final ArtifactClassLoader containerArtifactClassLoader;
    private final RegionPluginClassLoadersFactory regionPluginClassLoadersFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;

    public DomainClassLoaderFactory(ArtifactClassLoader containerArtifactClassLoader, RegionPluginClassLoadersFactory regionPluginClassLoadersFactory, PluginDependenciesResolver pluginDependenciesResolver) {
        Objects.requireNonNull(containerArtifactClassLoader, "containerArtifactClassLoader cannot be null");
        Objects.requireNonNull(regionPluginClassLoadersFactory, "regionPluginClassLoadersFactory cannot be null");
        Objects.requireNonNull(pluginDependenciesResolver, "pluginDependenciesResolver cannot be null");
        this.containerArtifactClassLoader = containerArtifactClassLoader;
        this.regionPluginClassLoadersFactory = regionPluginClassLoadersFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
    }

    public ToolingArtifactClassLoader createDomainClassLoader(DomainDescriptor domainDescriptor, File workingDirectory) {
        ToolingDomainClassLoaderBuilder domainClassLoaderBuilder = new ToolingDomainClassLoaderBuilder(this.containerArtifactClassLoader, DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> new File(workingDirectory, (String)name)), this.regionPluginClassLoadersFactory);
        domainClassLoaderBuilder.setArtifactDescriptor((ArtifactDescriptor)domainDescriptor);
        List resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(Collections.emptySet(), (List)ImmutableList.builder().addAll((Iterable)domainDescriptor.getPlugins()).build(), true);
        resolvedArtifactPluginDescriptors.stream().forEach(xva$0 -> domainClassLoaderBuilder.addArtifactPluginDescriptors(new ArtifactPluginDescriptor[]{xva$0}));
        return domainClassLoaderBuilder.build();
    }
}

