/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.internal.tooling.ToolingApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderSupplier;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.DefaultExtensionSchemaGenerator;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtensionModelService
implements InternalExtensionModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionModelService.class);
    private static final String JAR = "jar";
    private static final String MULE_APPLICATION = "mule-application";
    private static final String MAVEN_MODEL_VERSION = "4.0.0";
    private final MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;
    private final ExtensionSchemaGenerator schemaGenerator = new DefaultExtensionSchemaGenerator();
    private final List<ExtensionModel> runtimeExtensionModels = new ArrayList<ExtensionModel>();

    public DefaultExtensionModelService(MuleArtifactResourcesRegistry muleArtifactResourcesRegistry) {
        Objects.requireNonNull(muleArtifactResourcesRegistry, "muleArtifactResourcesRegistry cannot be null");
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
        this.runtimeExtensionModels.addAll(new ArrayList(ExtensionModelDiscoverer.discoverRuntimeExtensionModels()));
    }

    @Override
    public List<ExtensionModel> loadRuntimeExtensionModels() {
        return this.runtimeExtensionModels;
    }

    @Override
    public Optional<LoadedExtensionInformation> loadExtensionData(File pluginJarFile) {
        long startTime = System.nanoTime();
        org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor = this.readArtifactPluginDescriptor(pluginJarFile).getBundleDescriptor();
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        classLoaderModelAttributes.put("_classLoaderModelMavenReactorResolver", new PluginFileMavenReactor(bundleDescriptor, pluginJarFile, this.muleArtifactResourcesRegistry.getWorkingDirectory()));
        BundleDescriptor pluginDescriptor = new BundleDescriptor.Builder().setGroupId(bundleDescriptor.getGroupId()).setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId()).setVersion(bundleDescriptor.getVersion()).setClassifier((String)bundleDescriptor.getClassifier().orElse(null)).build();
        Optional<LoadedExtensionInformation> extensionInformationOptional = this.withTemporaryApplication(pluginDescriptor, classLoaderModelAttributes, (artifactPluginDescriptor, toolingArtifactClassLoader, properties) -> this.loadExtensionData(artifactPluginDescriptor, toolingArtifactClassLoader, (Map<String, String>)properties));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Extension model for {} loaded in {}ms", (Object)pluginJarFile, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        }
        return extensionInformationOptional;
    }

    @Override
    public Optional<LoadedExtensionInformation> loadExtensionData(ArtifactClassLoader artifactClassLoader, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return this.loadExtensionData((ArtifactPluginDescriptor)artifactClassLoader.getArtifactDescriptor(), artifactPluginClassLoaders, Collections.emptyMap());
    }

    @Override
    public BundleDescriptor readBundleDescriptor(File pluginFile) {
        org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor = this.readArtifactPluginDescriptor(pluginFile).getBundleDescriptor();
        return new BundleDescriptor.Builder().setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId()).setBaseVersion(bundleDescriptor.getVersion()).setVersion(bundleDescriptor.getVersion()).setType(bundleDescriptor.getType()).setClassifier((String)bundleDescriptor.getClassifier().orElse(null)).build();
    }

    private ArtifactPluginDescriptor readArtifactPluginDescriptor(File pluginFile) {
        try {
            ArtifactPluginDescriptor artifactPluginDescriptor = this.muleArtifactResourcesRegistry.getArtifactPluginDescriptorLoader().load(pluginFile);
            return artifactPluginDescriptor;
        }
        catch (Exception e) {
            throw new ToolingException("Error while loading ExtensionModel for plugin: " + pluginFile.getAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public Optional<LoadedExtensionInformation> loadExtensionData(BundleDescriptor pluginDescriptor) {
        long startTime = System.nanoTime();
        Optional<LoadedExtensionInformation> extensionInformationOptional = this.withTemporaryApplication(pluginDescriptor, Collections.emptyMap(), (artifactPluginDescriptor, toolingArtifactClassLoader, properties) -> this.loadExtensionData(artifactPluginDescriptor, toolingArtifactClassLoader, (Map<String, String>)properties));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Extension model for {} loaded in {}ms", (Object)pluginDescriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        }
        return extensionInformationOptional;
    }

    /*
     * Exception decompiling
     */
    private Optional<LoadedExtensionInformation> withTemporaryApplication(BundleDescriptor pluginDescriptor, Map<String, Object> classLoaderModelLoaderAttributes, TemporaryApplicationFunction action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createPomFile(BundleDescriptor pluginDescriptor, String uuid, File applicationFolder) {
        Model model = new Model();
        model.setGroupId(uuid);
        model.setArtifactId(uuid);
        model.setVersion(MuleManifest.getProductVersion());
        model.setPackaging(MULE_APPLICATION);
        model.setModelVersion(MAVEN_MODEL_VERSION);
        Dependency dependency = new Dependency();
        dependency.setGroupId(pluginDescriptor.getGroupId());
        dependency.setArtifactId(pluginDescriptor.getArtifactId());
        dependency.setVersion(pluginDescriptor.getVersion());
        dependency.setClassifier("mule-plugin");
        dependency.setType(JAR);
        model.getDependencies().add(dependency);
        MavenUtils.createDeployablePomFile((File)applicationFolder, (Model)model);
        MavenUtils.createDeployablePomProperties((File)applicationFolder, (Model)model);
    }

    private DeployableArtifactClassLoaderFactory<ApplicationDescriptor> newTemporaryArtifactClassLoaderFactory() {
        return (artifactId, parent, descriptor, artifactPluginClassLoaders) -> new MuleDeployableArtifactClassLoader(artifactId, descriptor, descriptor.getClassLoaderConfiguration().getUrls(), parent.getClassLoader(), parent.getClassLoaderLookupPolicy(), artifactPluginClassLoaders);
    }

    private Optional<LoadedExtensionInformation> loadExtensionData(ArtifactPluginDescriptor artifactPluginDescriptor, ToolingArtifactClassLoader toolingArtifactClassLoader, Map<String, String> properties) {
        try {
            ExtensionModelLoaderRepository extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager((ClassLoader)this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader().getClassLoader());
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
            Optional<LoadedExtensionInformation> optional = this.getLoadedExtensionInformation(artifactPluginDescriptor, toolingArtifactClassLoader.getArtifactPluginClassLoaders(), extensionModelLoaderRepository, properties);
            return optional;
        }
        catch (Exception e) {
            throw new ToolingException((Throwable)e);
        }
        finally {
            if (toolingArtifactClassLoader != null) {
                toolingArtifactClassLoader.dispose();
            }
        }
    }

    private Optional<LoadedExtensionInformation> loadExtensionData(ArtifactPluginDescriptor artifactPluginDescriptor, List<ArtifactClassLoader> artifactPluginClassLoaders, Map<String, String> properties) {
        try {
            ExtensionModelLoaderRepository extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager((ClassLoader)this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader().getClassLoader());
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
            return this.getLoadedExtensionInformation(artifactPluginDescriptor, artifactPluginClassLoaders, extensionModelLoaderRepository, properties);
        }
        catch (Exception e) {
            throw new ToolingException((Throwable)e);
        }
    }

    private Optional<LoadedExtensionInformation> getLoadedExtensionInformation(ArtifactPluginDescriptor pluginDescriptor, List<ArtifactClassLoader> artifactPluginClassLoaders, ExtensionModelLoaderRepository loaderRepository, Map<String, String> properties) {
        Set<ExtensionModel> descriptorsWithExtensions = this.discoverPluginsExtensionModel(artifactPluginClassLoaders, loaderRepository, properties).stream().map(extensionModel -> (ExtensionModel)ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), () -> {
            ExtensionModelJsonSerializer extensionModelJsonSerializer = new ExtensionModelJsonSerializer();
            return extensionModelJsonSerializer.deserialize(extensionModelJsonSerializer.serialize(extensionModel));
        })).collect(Collectors.toSet());
        Optional<ExtensionModel> foundExtension = this.getExtensionModel(pluginDescriptor, descriptorsWithExtensions);
        if (foundExtension.isPresent()) {
            LazyValue<String> lazySchema = this.getSchema(descriptorsWithExtensions, foundExtension.get());
            return Optional.of(new LoadedExtensionInformation(foundExtension.get(), lazySchema, pluginDescriptor.getMinMuleVersion().toString()));
        }
        return Optional.empty();
    }

    private LazyValue<String> getSchema(Set<ExtensionModel> extensionModels, ExtensionModel foundExtension) {
        return new LazyValue(() -> this.schemaGenerator.generate(foundExtension, DslResolvingContext.getDefault((Set)extensionModels)));
    }

    private Optional<ExtensionModel> getExtensionModel(ArtifactPluginDescriptor descriptor, Set<ExtensionModel> extensionModels) {
        if (extensionModels.isEmpty()) {
            return Optional.empty();
        }
        org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor artifactCoordinates = descriptor.getBundleDescriptor();
        return extensionModels.stream().filter(arg_0 -> DefaultExtensionModelService.lambda$getExtensionModel$10((ArtifactCoordinates)artifactCoordinates, arg_0)).findFirst();
    }

    private Set<ExtensionModel> discoverPluginsExtensionModel(List<ArtifactClassLoader> artifactPluginClassLoaders, ExtensionModelLoaderRepository extensionModelLoaderRepository, Map<String, String> properties) {
        ExtensionModelDiscoverer extensionModelDiscoverer = ExtensionModelDiscoverer.defaultExtensionModelDiscoverer((PluginClassLoaderSupplier)this.getPluginClassloaderSupplier(artifactPluginClassLoaders), (ExtensionModelLoaderRepository)extensionModelLoaderRepository);
        List artifactPluginDescriptors = artifactPluginClassLoaders.stream().map(a -> this.effectiveModel(properties, (ArtifactPluginDescriptor)a.getArtifactDescriptor())).collect(Collectors.toList());
        return extensionModelDiscoverer.discoverPluginsExtensionModels(ExtensionDiscoveryRequest.builder().setArtifactPlugins(artifactPluginDescriptors).build());
    }

    private PluginClassLoaderSupplier getPluginClassloaderSupplier(List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return artifactPluginDescriptor -> artifactPluginClassLoaders.stream().filter(apcl -> apcl.getArtifactDescriptor().getBundleDescriptor().getGroupId().equals(artifactPluginDescriptor.getBundleDescriptor().getGroupId()) && apcl.getArtifactDescriptor().getBundleDescriptor().getArtifactId().equals(artifactPluginDescriptor.getBundleDescriptor().getArtifactId())).findAny().get();
    }

    private ArtifactPluginDescriptor effectiveModel(Map<String, String> properties, ArtifactPluginDescriptor artifactDescriptor) {
        if (Boolean.valueOf(properties.getOrDefault("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", "false")).booleanValue()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Loading effective model for '%s'", artifactDescriptor.getBundleDescriptor()));
            }
            artifactDescriptor.getExtensionModelDescriptorProperty().ifPresent(extensionModelDescriptorProperty -> extensionModelDescriptorProperty.addAttributes((Map)ImmutableMap.of((Object)"EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", (Object)Boolean.TRUE)));
        }
        return artifactDescriptor;
    }

    private static /* synthetic */ boolean lambda$getExtensionModel$10(ArtifactCoordinates artifactCoordinates, ExtensionModel e) {
        return e.getArtifactCoordinates().map(extensionModelArtifactCoordinates -> extensionModelArtifactCoordinates.getArtifactId().equals(artifactCoordinates.getArtifactId()) && extensionModelArtifactCoordinates.getGroupId().equals(artifactCoordinates.getGroupId()) && extensionModelArtifactCoordinates.getVersion().equals(artifactCoordinates.getVersion())).orElse(false);
    }

    private static /* synthetic */ IllegalStateException lambda$withTemporaryApplication$4(BundleDescriptor pluginDescriptor) {
        return new IllegalStateException(String.format("Couldn't find plugin descriptor: %s", pluginDescriptor));
    }

    private static /* synthetic */ boolean lambda$withTemporaryApplication$3(BundleDescriptor pluginDescriptor, ArtifactClassLoader artifactPluginClassLoader) {
        return artifactPluginClassLoader.getArtifactDescriptor().getBundleDescriptor().getGroupId().equals(pluginDescriptor.getGroupId()) && artifactPluginClassLoader.getArtifactDescriptor().getBundleDescriptor().getArtifactId().equals(pluginDescriptor.getArtifactId());
    }

    private static /* synthetic */ void lambda$withTemporaryApplication$2(ToolingApplicationClassLoaderBuilder rec$, ArtifactPluginDescriptor xva$0) {
        rec$.addArtifactPluginDescriptors(new ArtifactPluginDescriptor[]{xva$0});
    }

    @FunctionalInterface
    static interface TemporaryApplicationFunction {
        public Optional<LoadedExtensionInformation> call(ArtifactPluginDescriptor var1, ToolingArtifactClassLoader var2, Map<String, String> var3);
    }

    class PluginFileMavenReactor
    implements MavenReactorResolver {
        private static final String POM_XML = "pom.xml";
        private static final String POM = "pom";
        private final org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor descriptor;
        private final File mulePluginJarFile;
        private final File temporaryFolder;

        public PluginFileMavenReactor(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor descriptor, File mulePluginJarFile, File workingDirectory) {
            this.descriptor = descriptor;
            this.mulePluginJarFile = mulePluginJarFile;
            this.temporaryFolder = new File(workingDirectory, UUID.getUUID());
            this.temporaryFolder.mkdirs();
            Model model = MavenUtils.getPomModelFromJar((File)mulePluginJarFile);
            MavenXpp3Writer writer = new MavenXpp3Writer();
            try (FileOutputStream outputStream = new FileOutputStream(new File(this.temporaryFolder, POM_XML));){
                writer.write((OutputStream)outputStream, model);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals(POM)) {
                    return new File(this.temporaryFolder, POM_XML);
                }
                return this.mulePluginJarFile;
            }
            return null;
        }

        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return Collections.singletonList(this.descriptor.getVersion());
            }
            return Collections.emptyList();
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return this.descriptor.getGroupId().equals(bundleDescriptor.getGroupId()) && this.descriptor.getArtifactId().equals(bundleDescriptor.getArtifactId()) && this.descriptor.getVersion().equals(bundleDescriptor.getVersion());
        }

        public void dispose() {
            try {
                FileUtils.deleteDirectory((File)this.temporaryFolder);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

