/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.classloader;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.sql.Driver;
import org.mule.module.artifact.classloader.ActiveMQResourceReleaser;
import org.mule.module.artifact.classloader.ClassLoaderResourceReleaser;
import org.mule.module.artifact.classloader.IBMMQResourceReleaser;
import org.mule.module.artifact.classloader.MvelClassLoaderReleaser;
import org.mule.module.artifact.classloader.ScalaClassValueReleaser;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class MulePluginClassLoader
extends MuleArtifactClassLoader {
    private static final String DB_RESOURCE_RELEASER_CLASS_LOCATION = "/org/mule/module/artifact/classloader/JdbcResourceReleaser.class";
    private String dbResourceReleaserClassLocation = "/org/mule/module/artifact/classloader/JdbcResourceReleaser.class";
    private final ResourceReleaser classLoaderReferenceReleaser = new ClassLoaderResourceReleaser(this);
    private volatile boolean shouldReleaseJdbcReferences = false;
    private volatile boolean shouldReleaseIbmMQResources = false;
    private volatile boolean shouldReleaseActiveMQReferences = false;
    private ResourceReleaser jdbcResourceReleaserInstance;
    private final ResourceReleaser scalaClassValueReleaserInstance = new ScalaClassValueReleaser();
    private final ResourceReleaser mvelClassLoaderReleaserInstance = new MvelClassLoaderReleaser(this);

    public MulePluginClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(artifactId, artifactDescriptor, urls, parent, lookupPolicy);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = super.loadClass(name, resolve);
        if (!(this.shouldReleaseJdbcReferences || !Driver.class.isAssignableFrom(clazz) || clazz.equals(Driver.class) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()))) {
            this.shouldReleaseJdbcReferences = true;
        }
        if (!this.shouldReleaseIbmMQResources && name.startsWith("com.ibm.mq")) {
            this.shouldReleaseIbmMQResources = true;
        }
        if (!this.shouldReleaseActiveMQReferences && name.startsWith("org.apache.activemq")) {
            this.shouldReleaseActiveMQReferences = true;
        }
        return clazz;
    }

    @Override
    protected void doDispose() {
        try {
            this.clearReferences();
        }
        catch (Exception e) {
            this.reportPossibleLeak(e, this.getArtifactId());
        }
        try {
            if (this.shouldReleaseJdbcReferences) {
                this.createResourceReleaserInstance().release();
            }
        }
        catch (Exception e) {
            this.reportPossibleLeak(e, this.getArtifactId());
        }
        if (this.shouldReleaseIbmMQResources) {
            new IBMMQResourceReleaser(this).release();
        }
        if (this.shouldReleaseActiveMQReferences) {
            new ActiveMQResourceReleaser(this).release();
        }
    }

    private void clearReferences() {
        this.classLoaderReferenceReleaser.release();
        this.scalaClassValueReleaserInstance.release();
        this.mvelClassLoaderReleaserInstance.release();
    }

    protected ResourceReleaser createResourceReleaserInstance() {
        if (this.jdbcResourceReleaserInstance == null) {
            this.jdbcResourceReleaserInstance = (ResourceReleaser)this.createInstance(this.dbResourceReleaserClassLocation);
        }
        return this.jdbcResourceReleaserInstance;
    }

    @Override
    public void setResourceReleaserClassLocation(String resourceReleaserClassLocation) {
        this.dbResourceReleaserClassLocation = resourceReleaserClassLocation;
    }

    private <T> T createInstance(String classLocation) {
        try {
            Class clazz = this.createClass(classLocation);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create instance from resource: " + classLocation, e);
        }
    }

    private Class createClass(String classLocation) {
        Class<?> clazz;
        InputStream classStream = null;
        try {
            classStream = this.getClass().getResourceAsStream(classLocation);
            byte[] classBytes = IOUtils.toByteArray((InputStream)classStream);
            classStream.close();
            clazz = this.defineClass(null, classBytes, 0, classBytes.length);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Can not create class from resource: " + classLocation, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)classStream);
        return clazz;
    }

    static {
        MulePluginClassLoader.registerAsParallelCapable();
    }
}

