/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public class DeployableArtifactDescriptor
extends ArtifactDescriptor {
    public static final String DEFAULT_DEPLOY_PROPERTIES_RESOURCE = "mule-deploy.properties";
    public static final String PROPERTY_REDEPLOYMENT_ENABLED = "redeployment.enabled";
    public static final String PROPERTY_CONFIG_RESOURCES = "config.resources";
    public static final String MULE_POM = "pom.xml";
    public static final String MULE_POM_PROPERTIES = "pom.properties";
    private boolean redeploymentEnabled = true;
    private File location;
    private Set<String> configResources;
    private Set<ArtifactPluginDescriptor> plugins = new HashSet<ArtifactPluginDescriptor>();
    private File logConfigFile;
    private Optional<Properties> deploymentProperties = Optional.empty();

    public DeployableArtifactDescriptor(String name) {
        super(name);
        this.configResources = this.getDefaultConfigResources();
    }

    public DeployableArtifactDescriptor(String name, Optional<Properties> deploymentProperties) {
        super(name);
        this.configResources = this.getDefaultConfigResources();
        this.deploymentProperties = deploymentProperties;
    }

    public boolean isRedeploymentEnabled() {
        return this.redeploymentEnabled;
    }

    public void setRedeploymentEnabled(boolean redeploymentEnabled) {
        this.redeploymentEnabled = redeploymentEnabled;
    }

    public void setArtifactLocation(File location) {
        this.location = location;
    }

    public File getArtifactLocation() {
        return this.location;
    }

    public Set<String> getConfigResources() {
        return this.configResources;
    }

    public void setConfigResources(Set<String> configResources) {
        this.configResources = this.sanitizePaths(configResources);
    }

    private Set<String> sanitizePaths(Set<String> configResources) {
        if (configResources == null || configResources.isEmpty()) {
            return configResources;
        }
        return configResources.stream().map(s -> FilenameUtils.separatorsToUnix((String)s)).collect(Collectors.toSet());
    }

    public Set<ArtifactPluginDescriptor> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Set<ArtifactPluginDescriptor> plugins) {
        this.plugins = plugins;
    }

    public String getDataFolderName() {
        return this.getArtifactLocation().getName();
    }

    public File getDescriptorFile() {
        return new File(this.getRootFolder(), MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION);
    }

    protected Set<String> getDefaultConfigResources() {
        return Collections.emptySet();
    }

    public void setLogConfigFile(File logConfigFile) {
        this.logConfigFile = logConfigFile;
    }

    public File getLogConfigFile() {
        return this.logConfigFile;
    }

    public Optional<Properties> getDeploymentProperties() {
        return this.deploymentProperties;
    }
}

