/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.parameterization;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;

public class ComponentParameterizationBuilder<M extends ParameterizedModel>
implements ComponentParameterization.Builder<M> {
    private M model;
    private final Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters = new HashMap<Pair<ParameterGroupModel, ParameterModel>, Object>();
    private Optional<ComponentIdentifier> identifier = Optional.empty();

    public ComponentParameterization.Builder<M> withModel(M model) {
        this.model = model;
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(String paramGroupName, String paramName, Object paramValue) throws IllegalArgumentException {
        ParameterGroupModel paramGroup = this.model.getParameterGroupModels().stream().filter(pgm -> pgm.getName().equals(paramGroupName)).findAny().orElseThrow(() -> new IllegalArgumentException("ParameterGroup does not exist: " + paramGroupName));
        ParameterModel parameter = paramGroup.getParameter(paramName).orElseThrow(() -> new IllegalArgumentException("Parameter does not exist in group '" + paramGroupName + "': " + paramName));
        this.parameters.put(new Pair<ParameterGroupModel, ParameterModel>(paramGroup, parameter), paramValue);
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(ParameterGroupModel paramGroup, ParameterModel paramModel, Object paramValue) {
        this.parameters.put(new Pair<ParameterGroupModel, ParameterModel>(paramGroup, paramModel), paramValue);
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(String paramName, Object paramValue) throws IllegalArgumentException {
        List paramGroupsWithParamNamed = this.model.getParameterGroupModels().stream().filter(pgm -> pgm.getParameter(paramName).isPresent()).collect(Collectors.toList());
        if (paramGroupsWithParamNamed.isEmpty()) {
            throw new IllegalArgumentException("Parameter does not exist in any group: " + paramName);
        }
        if (paramGroupsWithParamNamed.size() > 1) {
            throw new IllegalArgumentException("Parameter exists in more than one group (" + paramGroupsWithParamNamed.stream().map(pgm -> pgm.getName()).collect(Collectors.toList()) + "): " + paramName);
        }
        ParameterGroupModel paramGroup = (ParameterGroupModel)paramGroupsWithParamNamed.get(0);
        ParameterModel paramModel = ((ParameterGroupModel)paramGroupsWithParamNamed.get(0)).getParameter(paramName).get();
        return this.withParameter(paramGroup, paramModel, paramValue);
    }

    @Override
    public ComponentParameterization.Builder<M> withComponentIdentifier(ComponentIdentifier identifier) {
        this.identifier = Optional.of(identifier);
        return this;
    }

    @Override
    public ComponentParameterization<M> build() {
        return new DefaultComponentParameterization<M>(this.model, Collections.unmodifiableMap(this.parameters), this.identifier);
    }

    private static class DefaultComponentParameterization<M extends ParameterizedModel>
    implements ComponentParameterization<M> {
        private final M model;
        private final Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters;
        private final Map<Pair<String, String>, Object> parametersByNames;
        private final Optional<ComponentIdentifier> identifier;

        public DefaultComponentParameterization(M model, Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters, Optional<ComponentIdentifier> identifier) {
            this.model = model;
            this.parameters = parameters;
            this.identifier = identifier;
            this.parametersByNames = Collections.unmodifiableMap(parameters.entrySet().stream().collect(Collectors.toMap(e -> new Pair<String, String>(((ParameterGroupModel)((Pair)e.getKey()).getFirst()).getName(), ((ParameterModel)((Pair)e.getKey()).getSecond()).getName()), e -> e.getValue())));
        }

        @Override
        public M getModel() {
            return this.model;
        }

        @Override
        public Object getParameter(String paramGroupName, String paramName) {
            return this.parametersByNames.get(new Pair<String, String>(paramGroupName, paramName));
        }

        @Override
        public Object getParameter(ParameterGroupModel paramGroup, ParameterModel param) {
            return this.parameters.get(new Pair<ParameterGroupModel, ParameterModel>(paramGroup, param));
        }

        @Override
        public Map<Pair<ParameterGroupModel, ParameterModel>, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public void forEachParameter(ComponentParameterization.ParameterAction action) {
            this.parameters.entrySet().forEach(e -> action.accept((ParameterGroupModel)((Pair)e.getKey()).getFirst(), (ParameterModel)((Pair)e.getKey()).getSecond(), e.getValue()));
        }

        @Override
        public Optional<ComponentIdentifier> getComponentIdentifier() {
            return this.identifier;
        }
    }
}

