/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component;

import java.io.Serializable;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.IdentifierParsingUtils;
import org.mule.runtime.api.util.Preconditions;

class DefaultComponentIdentifier
implements ComponentIdentifier,
Serializable {
    private static final long serialVersionUID = -7904681927277956932L;
    private String namespace;
    private String namespaceLowerCase;
    private String namespaceUri;
    private String name;
    private int hash;

    private DefaultComponentIdentifier() {
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static ComponentIdentifier parseComponentIdentifier(String componentIdentifier) {
        return IdentifierParsingUtils.parseComponentIdentifier(componentIdentifier, "mule");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultComponentIdentifier that = (DefaultComponentIdentifier)o;
        if (!this.namespaceLowerCase.equals(that.namespaceLowerCase)) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.hash;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.getNamespace().equals("mule") ? this.getName() : this.getNamespace() + ":" + this.getName();
    }

    public static class Builder
    implements ComponentIdentifier.Builder {
        private final DefaultComponentIdentifier componentIdentifier = new DefaultComponentIdentifier();

        @Override
        public Builder namespace(String namespace) {
            this.componentIdentifier.namespace = namespace;
            this.componentIdentifier.namespaceLowerCase = namespace.toLowerCase();
            return this;
        }

        @Override
        public Builder namespaceUri(String namespaceUri) {
            this.componentIdentifier.namespaceUri = namespaceUri;
            return this;
        }

        @Override
        public Builder name(String identifier) {
            this.componentIdentifier.name = identifier;
            return this;
        }

        @Override
        public ComponentIdentifier build() {
            Preconditions.checkState(this.componentIdentifier.namespace != null && !this.componentIdentifier.namespace.trim().isEmpty(), "Prefix URI must be not blank");
            Preconditions.checkState(this.componentIdentifier.name != null && !this.componentIdentifier.name.trim().isEmpty(), "Name must be not blank");
            this.componentIdentifier.hash = this.componentIdentifier.namespaceLowerCase.hashCode();
            this.componentIdentifier.hash = 31 * this.componentIdentifier.hash + this.componentIdentifier.name.hashCode();
            return this.componentIdentifier;
        }
    }
}

