/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.oauth.internal.state;

public class StateDecoder {
    private String state;

    public StateDecoder(String state) {
        this.state = state;
    }

    public String decodeOriginalState() {
        String originalState = this.state;
        if (this.state != null) {
            int resourceOwnerIdSuffixIndex;
            int indexOfResourceOwnerParameter = this.state.indexOf(":resourceOwnerId=");
            int n = resourceOwnerIdSuffixIndex = indexOfResourceOwnerParameter != -1 ? indexOfResourceOwnerParameter : this.state.indexOf(":onCompleteRedirectTo=");
            if (resourceOwnerIdSuffixIndex != -1 && (originalState = this.state.substring(0, resourceOwnerIdSuffixIndex)).isEmpty()) {
                originalState = null;
            }
        }
        return originalState;
    }

    public String decodeResourceOwnerId() {
        return this.decodeParameter(":resourceOwnerId=");
    }

    public String decodeOnCompleteRedirectTo() {
        String parameterValue = null;
        if (this.state != null && this.state.contains(":onCompleteRedirectTo=")) {
            int onCompleteRedirectToSuffixIndex = this.state.indexOf(":onCompleteRedirectTo=");
            parameterValue = this.state.substring(onCompleteRedirectToSuffixIndex + ":onCompleteRedirectTo=".length(), this.state.length());
        }
        return parameterValue;
    }

    private String decodeParameter(String parameterNameAssignation) {
        String parameterValue = null;
        if (this.state != null && this.state.contains(parameterNameAssignation)) {
            int resourceOwnerIdSuffixIndex = this.state.indexOf(parameterNameAssignation);
            String stateCustomParameters = this.state.substring(resourceOwnerIdSuffixIndex + parameterNameAssignation.length(), this.state.length());
            int onCompleteRedirectToParamIndex = stateCustomParameters.indexOf(":onCompleteRedirectTo=");
            int endIndex = onCompleteRedirectToParamIndex != -1 ? onCompleteRedirectToParamIndex : stateCustomParameters.length();
            parameterValue = stateCustomParameters.substring(0, endIndex);
        }
        return parameterValue;
    }
}

