/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.validation.Location;
import org.mule.runtime.api.el.validation.Severity;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public abstract class AbstractExpressionSyntacticallyValid
implements Validation {
    protected final ExpressionLanguage expressionLanguage;
    private final Supplier<Validation.Level> level;
    private final Severity severity;

    public AbstractExpressionSyntacticallyValid(ExpressionLanguage expressionLanguage, Supplier<Validation.Level> level, Severity severity) {
        this.expressionLanguage = expressionLanguage;
        this.level = level;
        this.severity = severity;
    }

    protected final Stream<ValidationResultItem> validateExpression(ComponentAst component, ComponentParameterAst param, String expression) {
        return this.expressionLanguage.validate(expression).messages().stream().filter(msg -> msg.getSeverity().equals((Object)this.getSeverity())).map(msg -> ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)param, (Validation)this, (String)msg.getMessage(), this.locationToAdditionalData(msg.getLocation())));
    }

    protected final Map<String, String> locationToAdditionalData(Location location) {
        HashMap<String, String> additionalData = new HashMap<String, String>();
        additionalData.put("expressions.location.start.position.line", Integer.toString(location.getStartPosition().getLine()));
        additionalData.put("expressions.location.start.position.column", Integer.toString(location.getStartPosition().getColumn()));
        additionalData.put("expressions.location.start.position.offset", Integer.toString(location.getStartPosition().getOffset()));
        additionalData.put("expressions.location.end.position.line", Integer.toString(location.getEndPosition().getLine()));
        additionalData.put("expressions.location.end.position.line", Integer.toString(location.getEndPosition().getColumn()));
        additionalData.put("expressions.location.end.position.offset", Integer.toString(location.getEndPosition().getOffset()));
        return additionalData;
    }

    public final Validation.Level getLevel() {
        return this.level.get();
    }

    protected final Severity getSeverity() {
        return this.severity;
    }
}

