/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.tracing.customization.EventBasedInitialSpanInfoProvider;
import org.mule.runtime.core.api.tracing.customization.FixedNameEventBasedInitialSpanInfoProvider;
import org.mule.runtime.core.internal.routing.ExecutableRoute;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.profiling.tracing.EventBasedInitialSpanInfoProviderAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorRoute
extends AbstractComponent
implements MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorRoute.class);
    private final Processor processor;
    private EventBasedInitialSpanInfoProvider eventBasedInitialSpanInfoProvider = new FixedNameEventBasedInitialSpanInfoProvider("route");
    private FlowExceptionHandler messagingExceptionHandler = (exception, event) -> null;
    private MuleContext muleContext;

    public ProcessorRoute(Processor processor) {
        Objects.requireNonNull(processor, "processor can't be null");
        this.processor = processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.processor instanceof MuleContextAware) {
            ((MuleContextAware)this.processor).setMuleContext(context);
        }
    }

    public void setMessagingExceptionHandler(FlowExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    public void setEventBasedInitialSpanInfoProvider(EventBasedInitialSpanInfoProvider eventBasedInitialSpanInfoProvider) {
        this.eventBasedInitialSpanInfoProvider = eventBasedInitialSpanInfoProvider;
    }

    public void initialise() throws InitialisationException {
        if (this.processor instanceof DefaultMessageProcessorChainBuilder.MessagingExceptionHandlerAware) {
            ((DefaultMessageProcessorChainBuilder.MessagingExceptionHandlerAware)this.processor).setMessagingExceptionHandler(this.messagingExceptionHandler);
        }
        if (this.processor instanceof EventBasedInitialSpanInfoProviderAware) {
            ((EventBasedInitialSpanInfoProviderAware)this.processor).setEventBasedInitialSpanInfoProvider(this.eventBasedInitialSpanInfoProvider);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.processor, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.processor);
    }

    public boolean accepts(ExpressionManagerSession session) {
        return true;
    }

    ExecutableRoute toExecutableRoute() {
        return new ExecutableRoute(this);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.processor);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.processor, (Logger)LOGGER);
    }
}

