/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.serialization;

import com.mulesoft.mule.runtime.module.cluster.internal.serialization.DistributedValue;
import java.io.Serializable;
import org.mule.runtime.api.serialization.SerializationProtocol;

public final class ClusterDistributedObject<T>
implements Serializable {
    private static final long serialVersionUID = -5991764233175594789L;
    private transient SerializationProtocol serializationProtocol;
    private final DistributedValue<T> distributedValue = new DistributedValue();

    public static <T> ClusterDistributedObject<T> forValue(T value, SerializationProtocol serializationProtocol) {
        return new ClusterDistributedObject<T>(value, serializationProtocol);
    }

    public static <T> ClusterDistributedObject<T> forSerializedValue(byte[] bytes) {
        return new ClusterDistributedObject<T>(bytes);
    }

    public static <T> ClusterDistributedObject<T> createSerializedForValue(T value, SerializationProtocol serializationProtocol) {
        return new ClusterDistributedObject<T>(serializationProtocol.serialize(value));
    }

    private ClusterDistributedObject(T value, SerializationProtocol serializationProtocol) {
        this.distributedValue.setNaturalRepresentation(value);
        this.serializationProtocol = serializationProtocol;
    }

    private ClusterDistributedObject(byte[] bytes) {
        this.distributedValue.setSerializedRepresentation(bytes);
        this.serializationProtocol = null;
    }

    public DistributedValue serialize() {
        DistributedValue value = new DistributedValue();
        if (this.distributedValue.getSerializedRepresentation() != null && this.serializationProtocol == null) {
            value.setSerializedRepresentation(this.distributedValue.getSerializedRepresentation());
        } else {
            value.setSerializedRepresentation(this.serializationProtocol.serialize(this.distributedValue.getNaturalRepresentation()));
        }
        return value;
    }

    public ClusterDistributedObject deserialize(SerializationProtocol serializationProtocol) {
        byte[] bytes = this.distributedValue.getSerializedRepresentation();
        Object deserializedValue = bytes != null ? serializationProtocol.deserialize(bytes) : this.distributedValue.getNaturalRepresentation();
        return ClusterDistributedObject.forValue(deserializedValue, serializationProtocol);
    }

    public Object getValue() {
        return this.distributedValue.getValue();
    }

    public void setSerializationProtocol(SerializationProtocol serializationProtocol) {
        this.serializationProtocol = serializationProtocol;
    }
}

