/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.map;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.IMap;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterRuntimeException;
import com.mulesoft.mule.runtime.module.cluster.api.map.ClusterMap;
import com.mulesoft.mule.runtime.module.cluster.api.map.EntryListener;
import com.mulesoft.mule.runtime.module.cluster.internal.map.EventListenerWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class HazelcastClusterMap<K, V>
implements ClusterMap<K, V> {
    private final IMap<K, V> iMap;

    public HazelcastClusterMap(IMap<K, V> hazelcastInstanceMap) {
        this.iMap = hazelcastInstanceMap;
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener) {
        try {
            return this.iMap.addEntryListener(new EventListenerWrapper<K, V>(listener), true);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error adding entry listener", e);
        }
    }

    @Override
    public boolean removeEntryListener(UUID id) {
        try {
            return this.iMap.removeEntryListener(id.toString());
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error removing entry listener", e);
        }
    }

    @Override
    public int size() {
        try {
            return this.iMap.size();
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting map size", e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.iMap.isEmpty();
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error checking if map is empty", e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.iMap.containsKey(key);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error checking if map contains key", e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.iMap.containsValue(value);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error checking if map contains value", e);
        }
    }

    @Override
    public V get(Object key) {
        try {
            return (V)this.iMap.get(key);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting a value from a map", e);
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            return (V)this.iMap.put(key, value);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error putting an entry in a map", e);
        }
    }

    @Override
    public V remove(Object key) {
        try {
            return (V)this.iMap.remove(key);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error removing an entry from a map", e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        try {
            this.iMap.putAll(m);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error putting in a map", e);
        }
    }

    @Override
    public void clear() {
        try {
            this.iMap.clear();
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error clearing a map", e);
        }
    }

    @Override
    public Set<K> keySet() {
        try {
            return this.iMap.keySet();
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting the key set from a map", e);
        }
    }

    @Override
    public Collection<V> values() {
        try {
            return this.iMap.values();
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting the values from a map", e);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try {
            return this.iMap.entrySet();
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting the entry set from a map", e);
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        try {
            return (V)this.iMap.putIfAbsent(key, value);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on putIfAbsent", e);
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        try {
            return this.iMap.remove(key, value);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on remove", e);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        try {
            return this.iMap.replace(key, oldValue, newValue);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on replace", e);
        }
    }

    @Override
    public V replace(K key, V value) {
        try {
            return (V)this.iMap.replace(key, value);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on replace", e);
        }
    }
}

