/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.pref;

import com.mulesoft.licm.pref.AbstractLicensePreferences;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.prefs.BackingStoreException;

public abstract class AbstractPropertySetPreferences
extends AbstractLicensePreferences {
    private static final String PREFIX = "java.util.prefs:";
    protected static final String NULL_STRING = "null";
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public AbstractPropertySetPreferences() {
        this(null, "");
    }

    public AbstractPropertySetPreferences(AbstractPropertySetPreferences parent, String path) {
        super(parent, path);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return new String[0];
    }

    @Override
    protected String getSpi(String key) {
        String value = this.getPropertySet().getText(this.getFullPath(key));
        if (value.compareToIgnoreCase(NULL_STRING) == 0) {
            value = null;
        }
        return value;
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        byte[] result = def;
        String value = this.get(key, null);
        try {
            if (value != null) {
                result = AbstractPropertySetPreferences.base64ToByteArray(value);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return result;
    }

    protected String getFullPath(String key) {
        return PREFIX + this.absolutePath() + "//" + key;
    }

    @Override
    protected void putSpi(String key, String value) {
        if (value == null) {
            this.getPropertySet().setText(this.getFullPath(key), NULL_STRING);
        } else {
            this.getPropertySet().setText(this.getFullPath(key), value);
        }
    }

    @Override
    protected void removeSpi(String key) {
        this.getPropertySet().setText(this.getFullPath(key), NULL_STRING);
    }

    private static byte[] base64ToByteArray(String s) {
        byte[] alphaToInt = base64ToInt;
        int sLen = s.length();
        int numGroups = sLen / 4;
        if (4 * numGroups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missingBytesInLastGroup = 0;
        int numFullGroups = numGroups;
        if (sLen != 0) {
            if (s.charAt(sLen - 1) == '=') {
                ++missingBytesInLastGroup;
                --numFullGroups;
            }
            if (s.charAt(sLen - 2) == '=') {
                ++missingBytesInLastGroup;
            }
        }
        byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
        int inCursor = 0;
        int outCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int ch0 = AbstractPropertySetPreferences.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch1 = AbstractPropertySetPreferences.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch2 = AbstractPropertySetPreferences.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch3 = AbstractPropertySetPreferences.base64toInt(s.charAt(inCursor++), alphaToInt);
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            result[outCursor++] = (byte)(ch2 << 6 | ch3);
        }
        if (missingBytesInLastGroup != 0) {
            int ch0 = AbstractPropertySetPreferences.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch1 = AbstractPropertySetPreferences.base64toInt(s.charAt(inCursor++), alphaToInt);
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            if (missingBytesInLastGroup == 1) {
                int ch2 = AbstractPropertySetPreferences.base64toInt(s.charAt(inCursor++), alphaToInt);
                result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            }
        }
        return result;
    }

    private static int base64toInt(char c, byte[] alphaToInt) {
        byte result = alphaToInt[c];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return result;
    }

    protected abstract PropertySet getPropertySet();
}

