/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.optimizers.dynamic;

import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.AbstractParser;
import org.mule.mvel2.compiler.Accessor;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.AccessorOptimizer;
import org.mule.mvel2.optimizers.OptimizationNotSupported;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.mvel2.optimizers.dynamic.DynamicAccessor;
import org.mule.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicGetAccessor
implements DynamicAccessor {
    private char[] expr;
    private int start;
    private int offset;
    private int type;
    private int runcount;
    private boolean opt = false;
    private ParserContext context;
    private Accessor _safeAccessor;
    private Accessor _accessor;

    public DynamicGetAccessor(ParserContext context, char[] expr, int start, int offset, int type, Accessor _accessor) {
        this._safeAccessor = this._accessor = _accessor;
        this.type = type;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.context = context;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            this.opt = true;
            try {
                return this.optimize(ctx, elCtx, variableFactory);
            }
            catch (OptimizationNotSupported optimizationNotSupported) {
                // empty catch block
            }
        }
        return this._accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        ++this.runcount;
        return this._accessor.setValue(ctx, elCtx, variableFactory, value);
    }

    private Object optimize(Object ctx, Object elCtx, VariableResolverFactory variableResolverFactory) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        AccessorOptimizer ao = OptimizerFactory.getAccessorCompiler("ASM");
        switch (this.type) {
            case 0: {
                this._accessor = ao.optimizeAccessor(this.context, this.expr, this.start, this.offset, ctx, elCtx, variableResolverFactory, false, null);
                return ao.getResultOptPass();
            }
            case 3: {
                this._accessor = ao.optimizeObjectCreation(this.context, this.expr, this.start, this.offset, ctx, elCtx, variableResolverFactory);
                return this._accessor.getValue(ctx, elCtx, variableResolverFactory);
            }
            case 2: {
                this._accessor = ao.optimizeCollection(AbstractParser.getCurrentThreadParserContext(), ctx, null, this.expr, this.start, this.offset, ctx, elCtx, variableResolverFactory);
                return this._accessor.getValue(ctx, elCtx, variableResolverFactory);
            }
        }
        return null;
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
    }

    public int getRuncount() {
        return this.runcount;
    }

    public Class getKnownEgressType() {
        return this._safeAccessor.getKnownEgressType();
    }

    public Accessor getAccessor() {
        return this._accessor;
    }

    public Accessor getSafeAccessor() {
        return this._safeAccessor;
    }
}

