/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.togglz.core.repository.util.MapSerializer;
import org.togglz.core.util.DbUtils;
import org.togglz.core.util.Strings;

class SchemaUpdater {
    private final Connection connection;
    private final String tableName;
    private final MapSerializer serializer;

    protected SchemaUpdater(Connection connection, String tableName, MapSerializer serializer) {
        this.connection = connection;
        this.tableName = tableName;
        this.serializer = serializer;
    }

    protected boolean doesTableExist() throws SQLException {
        return this.isSuccessful("SELECT * FROM %TABLE%");
    }

    protected void migrateToVersion1() throws SQLException {
        this.execute("CREATE TABLE %TABLE% (FEATURE_NAME VARCHAR(100) PRIMARY KEY, FEATURE_ENABLED INTEGER, FEATURE_USERS VARCHAR(2000))");
    }

    protected boolean isSchemaVersion1() throws SQLException {
        return this.columnExists("FEATURE_NAME") && !this.columnExists("STRATEGY_ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateToVersion2() throws SQLException {
        this.execute("ALTER TABLE %TABLE% ADD STRATEGY_ID VARCHAR(200)");
        this.execute("ALTER TABLE %TABLE% ADD STRATEGY_PARAMS VARCHAR(2000)");
        Statement updateDataStmt = this.connection.createStatement(1003, 1008);
        try {
            ResultSet resultSet = null;
            try {
                resultSet = updateDataStmt.executeQuery(this.substitute("SELECT FEATURE_NAME, FEATURE_USERS, STRATEGY_ID, STRATEGY_PARAMS FROM %TABLE%"));
                while (resultSet.next()) {
                    String users = resultSet.getString("FEATURE_USERS");
                    if (!Strings.isNotBlank(users)) continue;
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("users", users);
                    String paramData = this.serializer.serialize(params);
                    resultSet.updateString("STRATEGY_PARAMS", paramData);
                    String strategyId = resultSet.getString("STRATEGY_ID");
                    if (Strings.isBlank(strategyId)) {
                        resultSet.updateString("STRATEGY_ID", "username");
                    }
                    resultSet.updateRow();
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                throw throwable;
            }
            DbUtils.closeQuietly(resultSet);
        }
        finally {
            DbUtils.closeQuietly(updateDataStmt);
        }
        this.execute("ALTER TABLE %TABLE% DROP COLUMN FEATURE_USERS");
    }

    private boolean columnExists(String column) throws SQLException {
        return this.isSuccessful("SELECT " + column + " FROM %TABLE%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSuccessful(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        try {
            statement.execute(this.substitute(sql));
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtils.closeQuietly(statement);
        }
        return true;
    }

    private void execute(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        try {
            statement.executeUpdate(this.substitute(sql));
        }
        finally {
            DbUtils.closeQuietly(statement);
        }
    }

    private String substitute(String s) {
        return s.replace("%TABLE%", this.tableName);
    }
}

