/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.time.clock;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import com.mulesoft.mule.runtime.gw.internal.time.clock.SystemClock;
import java.io.Serializable;

public abstract class Clock
implements Serializable {
    private static final long A_SECOND = 1000L;
    private static final long serialVersionUID = 2343112458335437523L;
    private static Clock atomicInstance;
    protected long millisecondsOffset = 0L;

    public DateTime now() {
        return this.currentTime().plus(this.millisecondsOffset);
    }

    protected abstract DateTime currentTime();

    public Clock correctWith(Clock atomicClock) {
        this.millisecondsOffset = atomicClock.now().getMillis() - this.currentTime().getMillis();
        return this;
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == null || !(anotherObject instanceof Clock)) {
            return false;
        }
        DateTime thisNow = this.now();
        DateTime otherNow = ((Clock)anotherObject).now();
        long millisDiff = Math.abs(thisNow.getMillis() - otherNow.getMillis());
        return millisDiff < 1000L;
    }

    public String toString() {
        return "[now: " + this.now() + ", clockCorrection(ms): " + this.millisecondsOffset + "]";
    }

    public static void setAtomic(Clock clock) {
        atomicInstance = clock;
    }

    public static Clock atomic() {
        return atomicInstance;
    }

    public static Clock system() {
        return new SystemClock();
    }

    public long offset() {
        return this.millisecondsOffset;
    }
}

