/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.util.NodeUtils;

public class AllOfRule
extends Rule {
    private List<Rule> rules;

    public AllOfRule(Rule ... rules) {
        this(Arrays.asList(rules));
    }

    public AllOfRule(List<Rule> rules) {
        this.rules = new ArrayList<Rule>(rules);
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (Rule rule : this.rules) {
            result.addAll(rule.getSuggestions(node, context));
        }
        return result;
    }

    public AllOfRule and(Rule rule) {
        this.rules.add(rule);
        return this;
    }

    @Nullable
    public Rule getMatchingRule(Node node) {
        if (this.matches(node)) {
            return this;
        }
        return null;
    }

    public List<Rule> getChildren() {
        return this.rules;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        for (Rule rule : this.rules) {
            if (rule.matches(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        for (Rule rule : this.rules) {
            if (rule.matches(node)) continue;
            return rule.apply(node);
        }
        for (Rule rule : this.rules) {
            node = rule.apply(node);
            if (!NodeUtils.isErrorResult(node)) continue;
            return node;
        }
        return this.createNodeUsingFactory(node, new Object[0]);
    }

    @Override
    public String getDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("All of :");
        int i = 0;
        for (Rule rule : this.rules) {
            if (i > 0) {
                desc.append(",");
            }
            desc.append(rule.getDescription());
            ++i;
        }
        return desc.toString();
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, ParsingContext context) {
        if (!pathToRoot.isEmpty()) {
            Node peek = pathToRoot.get(0);
            Rule innerRule = this.getMatchingRule(peek);
            if (innerRule != null) {
                List<Suggestion> suggestions = innerRule.getSuggestions(pathToRoot.subList(1, pathToRoot.size()), context);
                if (suggestions.isEmpty()) {
                    return this.getSuggestions(peek, context);
                }
                return suggestions;
            }
            return this.getSuggestions(peek, context);
        }
        return Collections.emptyList();
    }
}

