/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.xa;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import com.mulesoft.mule.runtime.bti.internal.xa.QueueSessionResourceHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAResource;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;

public class QueueManagerXaResourceProducer
extends ResourceBean
implements XAResourceProducer {
    private QueueManager queueManager;
    private final String uniqueName;
    private final Set<XAResource> xaResources = new HashSet<XAResource>();
    private final Map<XAResource, QueueSessionResourceHolder> queueSessionResourceHolders = new HashMap<XAResource, QueueSessionResourceHolder>();
    private final ReentrantLock xaResourcesLock = new ReentrantLock();
    private volatile boolean failed = false;

    public QueueManagerXaResourceProducer(QueueManager queueManager, String uniqueName) {
        this.queueManager = queueManager;
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public XAResourceHolderState startRecovery() throws RecoveryException {
        return new XAResourceHolderState((XAResourceHolder)new QueueSessionResourceHolder((XAResource)this.queueManager.getQueueSession(), this), (ResourceBean)this);
    }

    public void endRecovery() throws RecoveryException {
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        if (!(xaResource instanceof QueueSession)) {
            return null;
        }
        this.xaResourcesLock.lock();
        try {
            QueueSessionResourceHolder resourceHolder = this.queueSessionResourceHolders.get(xaResource);
            if (resourceHolder == null) {
                QueueSessionResourceHolder queueSessionResourceHolder = new QueueSessionResourceHolder(xaResource, this);
                queueSessionResourceHolder.addStateChangeEventListener(new StateChangeListener(){

                    public void stateChanged(XAStatefulHolder source, int oldState, int newState) {
                        if (newState == 0) {
                            QueueManagerXaResourceProducer.this.removeXaResource(((QueueSessionResourceHolder)source).getXAResource());
                        }
                    }

                    public void stateChanging(XAStatefulHolder source, int currentState, int futureState) {
                    }
                });
                this.queueSessionResourceHolders.put(xaResource, queueSessionResourceHolder);
                QueueSessionResourceHolder queueSessionResourceHolder2 = queueSessionResourceHolder;
                return queueSessionResourceHolder2;
            }
            QueueSessionResourceHolder queueSessionResourceHolder = resourceHolder;
            return queueSessionResourceHolder;
        }
        finally {
            this.xaResourcesLock.unlock();
        }
    }

    public void init() {
    }

    public void close() {
        ResourceRegistrar.unregister((XAResourceProducer)this);
        this.queueManager = null;
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        return null;
    }

    public Reference getReference() throws NamingException {
        return new Reference(QueueManagerXaResourceProducer.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    public void addXaResource(XAResource session) {
        this.xaResourcesLock.lock();
        try {
            this.xaResources.add(session);
        }
        finally {
            this.xaResourcesLock.unlock();
        }
    }

    public void removeXaResource(XAResource xaResource) {
        this.xaResourcesLock.lock();
        try {
            this.xaResources.remove(xaResource);
            this.queueSessionResourceHolders.remove(xaResource);
        }
        finally {
            this.xaResourcesLock.unlock();
        }
    }
}

