/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.api.jms;

import bitronix.tm.resource.jms.PoolingConnectionFactory;
import com.mulesoft.mule.runtime.bti.api.jms.XAConnectionFactoryWrapper;
import com.mulesoft.mule.runtime.bti.api.transaction.MuleTransactionManager;
import com.mulesoft.mule.runtime.bti.api.util.BitronixConfigurationUtil;
import com.mulesoft.mule.runtime.bti.internal.jms.BitronixConnectionInvocationHandler;
import com.mulesoft.mule.runtime.bti.internal.jms.BitronixJmsXaConnectionFactoryProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.jms.Connection;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.privileged.transaction.xa.XaResourceFactoryHolder;

public final class BitronixConnectionFactoryWrapper
extends AbstractComponent
implements XAConnectionFactoryWrapper,
Initialisable,
Disposable,
MuleContextAware {
    private static final String UNSUPPORTED_JMS_API = "JMS API 2.0 not fully implemented";
    protected static final int DEFAULT_MIN_POOL_SIZE = 4;
    protected static final int DEFAULT_MAX_POOL_SIZE = 32;
    protected static final int DEFAULT_MAX_IDLE_TIME = 60;
    private int minPoolSize = 4;
    private int maxPoolSize = 32;
    private int maxIdleTime = 60;
    private String name;
    private XAConnectionFactory connectionFactory;
    private String username;
    private String password;
    private PoolingConnectionFactory factory;
    private MuleContext muleContext;

    public Connection createConnection() throws JMSException {
        this.initializePoolingConnectionFactory();
        Connection xac = this.factory.createConnection();
        Connection proxy = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new BitronixConnectionInvocationHandler(xac)));
        return proxy;
    }

    public Connection createConnection(String username, String password) throws JMSException {
        this.initializePoolingConnectionFactory();
        Connection xac = this.factory.createConnection(username, password);
        Connection proxy = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new BitronixConnectionInvocationHandler(xac)));
        return proxy;
    }

    public JMSContext createContext() {
        throw new UnsupportedOperationException(UNSUPPORTED_JMS_API);
    }

    public JMSContext createContext(String userName, String password) {
        throw new UnsupportedOperationException(UNSUPPORTED_JMS_API);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        throw new UnsupportedOperationException(UNSUPPORTED_JMS_API);
    }

    public JMSContext createContext(int sessionMode) {
        throw new UnsupportedOperationException(UNSUPPORTED_JMS_API);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializePoolingConnectionFactory() {
        if (this.factory != null) {
            return;
        }
        this.factory = new PoolingConnectionFactory();
        this.factory.setAutomaticEnlistingEnabled(false);
        this.factory.setMaxPoolSize(this.maxPoolSize);
        this.factory.setMinPoolSize(this.minPoolSize);
        this.factory.setMaxIdleTime(this.maxIdleTime);
        this.factory.setCacheProducersConsumers(false);
        this.factory.setAllowLocalTransactions(true);
        this.factory.setUniqueName(BitronixConfigurationUtil.createUniqueIdForResource(this.muleContext, this.name));
        this.factory.setUser(this.username);
        this.factory.setPassword(this.password);
        Class<BitronixJmsXaConnectionFactoryProvider> clazz = BitronixJmsXaConnectionFactoryProvider.class;
        synchronized (BitronixJmsXaConnectionFactoryProvider.class) {
            this.factory.setClassName(BitronixJmsXaConnectionFactoryProvider.class.getCanonicalName());
            this.factory.setConstructorArgs(new Object[]{this.connectionFactory});
            this.factory.init();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized void close() {
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public void initialise() throws InitialisationException {
        Objects.requireNonNull(this.name, "name is required");
        Objects.requireNonNull(this.connectionFactory, "connectionFactory is required");
        Preconditions.checkState((this.minPoolSize >= 0 ? 1 : 0) != 0, (String)"minPoolSize must be greater or equal than 0");
        Preconditions.checkState((this.maxPoolSize > 0 ? 1 : 0) != 0, (String)"maxPoolSize must be greater than 0");
        Preconditions.checkState((this.maxIdleTime > 0 ? 1 : 0) != 0, (String)"maxIdleTime must be greater than 0");
        if (!(this.muleContext.getTransactionManager() instanceof MuleTransactionManager)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Cannot use a Bitronix connection factory pool without using Bitronix transaction manager"), (Initialisable)this);
        }
    }

    public void dispose() {
        this.close();
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XAConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(XAConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

