/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.utils;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemCompiler;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.ModelFactory;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;

public class CommonMetadataFactory {
    public static final String MIME_APPLICATION_JSON = "application/json";
    public static final String MIME_APPLICATION_XML = "application/xml";
    public static final String MIME_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MIME_APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final MetadataType DEFAULT_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build();

    public static MetadataType defaultMetadata() {
        return DEFAULT_METADATA;
    }

    public static MetadataType fromXSDSchema(String xsdSchema) {
        Optional<QName> rootElementName;
        try {
            rootElementName = CommonMetadataFactory.getXmlSchemaRootElementName(xsdSchema);
        }
        catch (XmlException e) {
            return CommonMetadataFactory.defaultMetadata();
        }
        return rootElementName.map(qName -> {
            XmlTypeLoader xmlTypeLoader = new XmlTypeLoader(SchemaCollector.getInstance().addSchema("", xsdSchema));
            return xmlTypeLoader.load(qName.toString()).orElse(CommonMetadataFactory.defaultMetadata());
        }).orElse(CommonMetadataFactory.defaultMetadata());
    }

    private static Optional<QName> getXmlSchemaRootElementName(String xsdSchema) throws XmlException {
        XmlObject schemaObject;
        XmlOptions options = new XmlOptions();
        options.setCompileNoUpaRule();
        options.setCompileNoValidation();
        options.setCompileDownloadUrls();
        XmlObject[] schemaRepresentation = new XmlObject[1];
        SchemaTypeLoader contextTypeLoader = SchemaTypeLoaderImpl.build((SchemaTypeLoader[])new SchemaTypeLoader[]{BuiltinSchemaTypeSystem.get()}, null, (ClassLoader)CommonMetadataFactory.class.getClassLoader());
        schemaRepresentation[0] = schemaObject = contextTypeLoader.parse(xsdSchema, null, null);
        SchemaTypeSystemImpl schemaTypeSystem = SchemaTypeSystemCompiler.compile(null, null, (XmlObject[])schemaRepresentation, null, (SchemaTypeLoader)contextTypeLoader, null, (XmlOptions)options);
        SchemaGlobalElement[] globalElements = schemaTypeSystem.globalElements();
        if (globalElements.length == 1) {
            return Optional.ofNullable(globalElements[0].getName());
        }
        return Optional.empty();
    }

    public static MetadataType fromXMLExample(String xmlExample) {
        try {
            ModelFactory modelFactory = ModelFactory.fromExample((String)xmlExample);
            return new XmlTypeLoader(modelFactory).load(null).orElse(null);
        }
        catch (AssertionError | Exception e) {
            return null;
        }
    }
}

