/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinateFactory;
import org.mule.module.apikit.metadata.internal.model.ApikitConfig;
import org.mule.module.apikit.metadata.internal.model.ApikitElementIdentifiers;
import org.mule.module.apikit.metadata.internal.model.Flow;
import org.mule.module.apikit.metadata.internal.model.FlowMapping;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

public class ApplicationModelWrapper {
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_API_DEFINITION = "api";
    private static final String PARAMETER_RAML_DEFINITION = "raml";
    private static final String PARAMETER_OUTPUT_HEADERS_VAR = "outboundHeadersMapName";
    private static final String PARAMETER_HTTP_STATUS_VAR = "httpStatusVarName";
    private static final String PARAMETER_PARSER = "parser";
    private static final String PARAMETER_RESOURCE = "resource";
    private static final String PARAMETER_ACTION = "action";
    private static final String PARAMETER_CONTENT_TYPE = "content-type";
    private static final String PARAMETER_FLOW_REF = "flow-ref";
    private static final ComponentIdentifier FLOW = ComponentIdentifier.buildFromStringRepresentation((String)"flow");
    private static final ComponentIdentifier APIKIT_CONFIG = ComponentIdentifier.buildFromStringRepresentation((String)"apikit:config");
    private final ArtifactAst applicationModel;
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;
    private final Map<String, ApikitConfig> configMap;
    private final Map<String, ApiCoordinate> metadataFlows;
    private static final String groupFlowMapping = "FlowMapping";
    private static final String groupGeneral = "General";

    public ApplicationModelWrapper(ArtifactAst applicationModel, ResourceLoader loader, Notifier notifier) {
        this.applicationModel = applicationModel;
        this.resourceLoader = loader;
        this.notifier = notifier;
        this.configMap = this.loadConfigs();
        this.metadataFlows = this.loadFlows();
    }

    private Map<String, ApiCoordinate> loadFlows() {
        List<Flow> flows = this.findFlows();
        ApiCoordinateFactory coordsFactory = new ApiCoordinateFactory(this.getConfigNames());
        Map<String, ApiCoordinate> conventionCoordinates = this.createCoordinatesForConventionFlows(flows, coordsFactory);
        Map<String, ApiCoordinate> flowMappingCoordinates = this.createCoordinatesForMappingFlows(flows, coordsFactory);
        HashMap<String, ApiCoordinate> result = new HashMap<String, ApiCoordinate>(conventionCoordinates);
        result.putAll(flowMappingCoordinates);
        return result;
    }

    private Map<String, ApikitConfig> loadConfigs() {
        return this.applicationModel.topLevelComponentsStream().filter(ApplicationModelWrapper::isApikitConfig).map(this::createApikitConfig).collect(Collectors.toMap(ApikitConfig::getName, Function.identity()));
    }

    private Set<String> getConfigNames() {
        return this.configMap.keySet();
    }

    Collection<ApikitConfig> getConfigurations() {
        return this.configMap.values();
    }

    private Map<String, ApiCoordinate> createCoordinatesForConventionFlows(List<Flow> flows, ApiCoordinateFactory coordsFactory) {
        return flows.stream().map(flow -> coordsFactory.fromFlowName(flow.getName())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ApiCoordinate::getFlowName, Function.identity()));
    }

    private ApikitConfig createApikitConfig(ComponentAst config) {
        String configName = (String)config.getParameter(groupGeneral, PARAMETER_NAME).getValue().getRight();
        String apiDefinition = ApplicationModelWrapper.getApiDefinition(config);
        String outputHeadersVarName = (String)config.getParameter(groupGeneral, PARAMETER_OUTPUT_HEADERS_VAR).getValue().getRight();
        String httpStatusVarName = (String)config.getParameter(groupGeneral, PARAMETER_HTTP_STATUS_VAR).getValue().getRight();
        String parser = config.getParameter(groupGeneral, PARAMETER_PARSER).getValue().getRight().toString();
        List flowMappings = (List)config.getParameter(groupGeneral, "flowMappings").getValue().reduce(l -> Collections.emptyList(), r -> ((List)r).stream().filter(flowMapping -> ApikitElementIdentifiers.isFlowMapping(flowMapping.getIdentifier())).map(unwrappedFlowMapping -> ApplicationModelWrapper.createFlowMapping(configName, unwrappedFlowMapping)).collect(Collectors.toList()));
        return new ApikitConfig(configName, apiDefinition, flowMappings == null ? Collections.emptyList() : flowMappings, httpStatusVarName, outputHeadersVarName, parser, this.resourceLoader, this.notifier);
    }

    private static String getApiDefinition(ComponentAst config) {
        if (config.getParameter(groupGeneral, PARAMETER_API_DEFINITION).getValue().getRight() != null) {
            return (String)config.getParameter(groupGeneral, PARAMETER_API_DEFINITION).getValue().getRight();
        }
        if (config.getParameter(groupGeneral, PARAMETER_RAML_DEFINITION).getValue().getRight() != null) {
            return (String)config.getParameter(groupGeneral, PARAMETER_RAML_DEFINITION).getValue().getRight();
        }
        return null;
    }

    public List<Flow> findFlows() {
        return ApplicationModelWrapper.findFlows(this.applicationModel);
    }

    public static List<Flow> findFlows(ArtifactAst applicationModel) {
        return applicationModel.topLevelComponentsStream().filter(ApplicationModelWrapper::isFlow).map(ApplicationModelWrapper::createFlow).collect(Collectors.toList());
    }

    private static Flow createFlow(ComponentAst componentModel) {
        return new Flow(componentModel.getComponentId().orElse(null));
    }

    public Optional<ApiCoordinate> getApiCoordinate(String flowName) {
        return Optional.ofNullable(this.metadataFlows.get(flowName));
    }

    public Optional<ApikitConfig> getConfig(String name) {
        if (this.configMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.configMap.getOrDefault(name, this.configMap.values().iterator().next()));
    }

    private Map<String, ApiCoordinate> createCoordinatesForMappingFlows(List<Flow> flows, ApiCoordinateFactory factory) {
        Set flowNames = flows.stream().map(Flow::getName).collect(Collectors.toSet());
        return this.configMap.values().stream().flatMap(config -> config.getFlowMappings().stream()).filter(mapping -> flowNames.contains(mapping.getFlowRef())).map(factory::createFromFlowMapping).collect(Collectors.toMap(ApiCoordinate::getFlowName, Function.identity()));
    }

    private static boolean isFlow(ComponentAst component) {
        return component.getIdentifier().equals(FLOW);
    }

    private static boolean isApikitConfig(ComponentAst component) {
        return component.getIdentifier().equals(APIKIT_CONFIG);
    }

    private static FlowMapping createFlowMapping(String configName, ComponentAst component) {
        String resource = (String)component.getParameter(groupFlowMapping, PARAMETER_RESOURCE).getValue().getRight();
        String action = (String)component.getParameter(groupFlowMapping, PARAMETER_ACTION).getValue().getRight();
        String contentType = (String)component.getParameter(groupFlowMapping, PARAMETER_CONTENT_TYPE).getValue().getRight();
        String flowRef = (String)component.getParameter(groupFlowMapping, PARAMETER_FLOW_REF).getValue().getRight();
        return new FlowMapping(configName, resource, action, contentType, flowRef);
    }
}

