/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.domain.monitoring;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mulesoft.agent.domain.monitoring.FlowMetrics;
import com.mulesoft.agent.domain.monitoring.Metric;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationMetrics {
    private final String applicationName;
    private final List<Metric> metrics;
    private final Map<String, FlowMetrics> flowMetrics;

    private static Map<String, FlowMetrics> flowMetricsListToMapByName(List<FlowMetrics> flowMetrics) {
        HashMap flowMetricsMap = Maps.newHashMap();
        if (flowMetrics != null) {
            for (FlowMetrics flowMetric : flowMetrics) {
                if (flowMetric == null) continue;
                flowMetricsMap.put(flowMetric.getFlowName(), flowMetric);
            }
        }
        return flowMetricsMap;
    }

    public ApplicationMetrics(String applicationName, List<Metric> metrics, List<FlowMetrics> flowMetrics) {
        this(applicationName, metrics, ApplicationMetrics.flowMetricsListToMapByName(flowMetrics));
    }

    public ApplicationMetrics(String applicationName, List<Metric> metrics, Map<String, FlowMetrics> flowMetrics) {
        this.applicationName = applicationName;
        this.flowMetrics = Collections.unmodifiableMap(flowMetrics);
        this.metrics = metrics != null ? metrics : Lists.newLinkedList();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public Map<String, FlowMetrics> getFlowMetrics() {
        return this.flowMetrics;
    }
}

