/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.common;

import java.io.File;

public class SecurityConfiguration {
    private static final String MULE_AGENT_JKS = "mule-agent.jks";
    private static final String TRUSTSTORE_JKS = "anypoint-truststore.jks";
    private String keyStorePassword;
    private String keyStoreAlias;
    private String keyStoreAliasPassword;
    private String keyStoreFileName;
    private String trustStoreFileName;

    public SecurityConfiguration(String keyStorePassword, String keyStoreAlias, String keyStoreAliasPassword, String keyStoreFileName, String trustStoreFileName) {
        this.keyStorePassword = keyStorePassword;
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreAliasPassword = keyStoreAliasPassword;
        this.keyStoreFileName = keyStoreFileName;
        this.trustStoreFileName = trustStoreFileName;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public String getKeyStoreAliasPassword() {
        return this.keyStoreAliasPassword;
    }

    public String getTrustStoreFile() {
        return System.getProperty("mule.agent.configuration.folder") + File.separator + (this.trustStoreFileName != null ? this.trustStoreFileName : TRUSTSTORE_JKS);
    }

    public String getKeyStoreFile() {
        return System.getProperty("mule.agent.configuration.folder") + File.separator + (this.keyStoreFileName != null ? this.keyStoreFileName : MULE_AGENT_JKS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityConfiguration)) {
            return false;
        }
        SecurityConfiguration that = (SecurityConfiguration)o;
        if (this.getKeyStorePassword() != null ? !this.getKeyStorePassword().equals(that.getKeyStorePassword()) : that.getKeyStorePassword() != null) {
            return false;
        }
        if (this.getKeyStoreAlias() != null ? !this.getKeyStoreAlias().equals(that.getKeyStoreAlias()) : that.getKeyStoreAlias() != null) {
            return false;
        }
        if (this.getKeyStoreAliasPassword() != null ? !this.getKeyStoreAliasPassword().equals(that.getKeyStoreAliasPassword()) : that.getKeyStoreAliasPassword() != null) {
            return false;
        }
        if (this.keyStoreFileName != null ? !this.keyStoreFileName.equals(that.keyStoreFileName) : that.keyStoreFileName != null) {
            return false;
        }
        return this.trustStoreFileName != null ? this.trustStoreFileName.equals(that.trustStoreFileName) : that.trustStoreFileName == null;
    }

    public int hashCode() {
        int result = this.getKeyStorePassword() != null ? this.getKeyStorePassword().hashCode() : 0;
        result = 31 * result + (this.getKeyStoreAlias() != null ? this.getKeyStoreAlias().hashCode() : 0);
        result = 31 * result + (this.getKeyStoreAliasPassword() != null ? this.getKeyStoreAliasPassword().hashCode() : 0);
        result = 31 * result + (this.keyStoreFileName != null ? this.keyStoreFileName.hashCode() : 0);
        result = 31 * result + (this.trustStoreFileName != null ? this.trustStoreFileName.hashCode() : 0);
        return result;
    }
}

