/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.IllegalPasswordException;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.Policy;
import de.schlichtherle.util.ObfuscatedString;
import de.schlichtherle.xml.GenericCertificate;
import de.schlichtherle.xml.PersistenceService;
import de.schlichtherle.xml.PersistenceServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;

public class PrivacyGuard {
    private static final String PBE_WITH_MD5_AND_DES = new ObfuscatedString(new long[]{2860604316472308139L, 5030391952891038168L, -6110818099732428353L}).toString();
    private static final String AES_CBC_PKCS5Padding = new ObfuscatedString(new long[]{9134146434932393082L, 3218103396305942830L, -2754183109520092056L, -3550530648860737056L}).toString();
    private static final String AES = new ObfuscatedString(new long[]{2384870410100050833L, -8534981221243966067L}).toString();
    private static final String SALT = new ObfuscatedString(new long[]{6868215648901611394L, -4636343031852078731L, 3158976241785645161L, 3605875122779352041L, 2444988390064642384L}).toString();
    private static final String PBKDF2_WITH_HMAC_SHA256 = new ObfuscatedString(new long[]{4969671083990297104L, -302967342919482453L, 8203409604234729237L, 3990919853171785823L}).toString();
    private CipherParam param;
    private Cipher cipher;
    private SecretKey key;
    private AlgorithmParameterSpec algoParamSpec;
    private boolean fipsEnabled;

    protected PrivacyGuard() {
    }

    public PrivacyGuard(CipherParam cipherParam, boolean bl) {
        this.fipsEnabled = bl;
        this.setCipherParam(cipherParam);
    }

    public PrivacyGuard(CipherParam cipherParam) {
        this(cipherParam, false);
    }

    public CipherParam getCipherParam() {
        return this.param;
    }

    public void setCipherParam(CipherParam cipherParam) throws NullPointerException, IllegalPasswordException {
        if (cipherParam == null) {
            throw new NullPointerException(LicenseNotary.PARAM);
        }
        Policy.getCurrent().checkPwd(cipherParam.getKeyPwd());
        this.param = cipherParam;
        this.cipher = null;
        this.key = null;
        this.algoParamSpec = null;
    }

    public byte[] cert2key(GenericCertificate genericCertificate) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new CipherOutputStream(byteArrayOutputStream, this.getCipher4Encryption()));
        try {
            PersistenceService.store((Object)genericCertificate, (OutputStream)gZIPOutputStream);
        }
        catch (PersistenceServiceException persistenceServiceException) {
            throw new AssertionError((Object)persistenceServiceException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericCertificate key2cert(byte[] byArray) throws Exception {
        GenericCertificate genericCertificate;
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(this.getCipher4Decryption().doFinal(byArray)));
        try {
            genericCertificate = (GenericCertificate)PersistenceService.load((InputStream)gZIPInputStream);
        }
        finally {
            try {
                ((InputStream)gZIPInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return genericCertificate;
    }

    protected Cipher getCipher4Encryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(1, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AssertionError((Object)invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError((Object)invalidAlgorithmParameterException);
        }
        return cipher;
    }

    protected Cipher getCipher4Decryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(2, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AssertionError((Object)invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError((Object)invalidAlgorithmParameterException);
        }
        return cipher;
    }

    public static SecretKey generateSecretKey(char[] cArray, byte[] byArray, int n, int n2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n, n2);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBKDF2_WITH_HMAC_SHA256);
        return secretKeyFactory.generateSecret(pBEKeySpec);
    }

    protected Cipher getCipher() {
        if (this.fipsEnabled) {
            return this.getCipherForFips();
        }
        return this.getCipherForNonFips();
    }

    private Cipher getCipherForNonFips() {
        if (this.cipher != null) {
            return this.cipher;
        }
        this.algoParamSpec = new PBEParameterSpec(new byte[]{-50, -5, -34, -84, 5, 2, 25, 113}, 2005);
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(this.getCipherParam().getKeyPwd().toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBE_WITH_MD5_AND_DES);
            this.key = secretKeyFactory.generateSecret(pBEKeySpec);
            this.cipher = Cipher.getInstance(PBE_WITH_MD5_AND_DES);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new AssertionError((Object)invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new AssertionError((Object)noSuchPaddingException);
        }
        return this.cipher;
    }

    private Cipher getCipherForFips() {
        char[] cArray = this.getCipherParam().getKeyPwd().toCharArray();
        byte[] byArray = Hex.decode((String)SALT);
        int n = 65536;
        int n2 = 256;
        byte[] byArray2 = new byte[16];
        try {
            this.key = PrivacyGuard.generateSecretKey(cArray, byArray, n, n2);
            this.cipher = Cipher.getInstance(AES_CBC_PKCS5Padding);
            this.algoParamSpec = new IvParameterSpec(byArray2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.key.getEncoded(), AES);
            return this.cipher;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

