/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.traversers.override;

import java.util.ArrayList;
import java.util.HashMap;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.traversers.XSDHandler;
import org.mule.apache.xerces.impl.xs.traversers.override.OverrideTransformException;
import org.mule.apache.xerces.impl.xs.traversers.override.OverrideTransformer;
import org.mule.apache.xerces.util.DOMUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public final class DOMOverrideImpl
extends OverrideTransformer {
    private final ArrayList fOverrideComponents = new ArrayList();
    private final HashMap[] fOverrideComponentsMap = new HashMap[]{null, new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap()};
    private Document fOverridenDoc;
    private Element fOverrideElem;
    private boolean hasPerformedTransformations = false;
    private DOMImplementation fDOMImpl;
    private final XSDHandler fSchemaHandler;

    public DOMOverrideImpl(XSDHandler schemaHandler) {
        this.fSchemaHandler = schemaHandler;
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            this.fDOMImpl = registry.getDOMImplementation("XML 3.0");
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void clearState() {
        this.fOverrideComponents.clear();
        for (int i = 1; i < this.fOverrideComponentsMap.length; ++i) {
            this.fOverrideComponentsMap[i].clear();
        }
        this.fOverridenDoc = null;
        this.fOverrideElem = null;
        this.hasPerformedTransformations = false;
    }

    @Override
    public Element transform(Element overrideElement, Element overridenSchema) throws OverrideTransformException {
        this.fOverridenDoc = this.cloneOverridenSchema(overridenSchema);
        Element overridenSchemaRoot = this.fOverridenDoc.getDocumentElement();
        this.fOverrideElem = overrideElement;
        this.fillOverrideElementMap(this.fOverrideElem);
        this.transform(overridenSchemaRoot, false);
        if (this.hasOverrideTransformations()) {
            this.clearState();
            return overridenSchemaRoot;
        }
        this.clearState();
        return null;
    }

    public boolean hasOverrideTransformations() {
        return this.hasPerformedTransformations;
    }

    private void transform(Element overridenSchemaRoot, boolean isOverrideRoot) {
        Element child = DOMUtil.getFirstChildElement(overridenSchemaRoot);
        while (child != null) {
            String localName = this.getLocalName(child);
            if (!localName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                if (localName.equals(SchemaSymbols.ELT_INCLUDE)) {
                    Element temp = this.fOverrideElem;
                    String newSchemaLocation = child.getAttribute(SchemaSymbols.ATT_SCHEMALOCATION);
                    child = this.performDOMOverride(overridenSchemaRoot, temp, child);
                    child.setAttribute(SchemaSymbols.ATT_SCHEMALOCATION, newSchemaLocation);
                    this.hasPerformedTransformations = true;
                } else if (localName.equals(SchemaSymbols.ELT_REDEFINE)) {
                    this.transform(child, false);
                } else if (localName.equals(SchemaSymbols.ELT_OVERRIDE)) {
                    this.transform(child, true);
                    this.mergeOverride(child);
                } else {
                    int componentType;
                    String componentName = DOMUtil.getAttrValue(child, SchemaSymbols.ATT_NAME);
                    if (componentName.length() != 0 && (componentType = this.getOverrideType(localName)) != 0) {
                        OverrideElement newNode = this.getMatchingOverrideElement(componentType, componentName);
                        Element oldNode = child;
                        if (newNode != null) {
                            child = this.performDOMOverride(overridenSchemaRoot, newNode.originalElement, oldNode);
                            if (!child.isEqualNode(oldNode)) {
                                this.hasPerformedTransformations = true;
                            }
                            if (isOverrideRoot) {
                                newNode.overrideCloned = true;
                            }
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
    }

    private void fillOverrideElementMap(Element overrideElement) {
        Element child = DOMUtil.getFirstChildElement(overrideElement);
        while (child != null) {
            String localName = this.getLocalName(child);
            if (!localName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                int componentOverrideType = this.getOverrideType(localName);
                if (componentOverrideType != 0) {
                    this.addOverrideElement(componentOverrideType, child);
                } else {
                    this.fSchemaHandler.reportSchemaError("s4s-elt-must-match.1", new Object[]{"override", "(annotation | (simpleType | complexType | group | attributeGroup | element | attribute | notation))*", DOMUtil.getLocalName(child)}, child);
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
    }

    private void addOverrideElement(int componentType, Element elem) {
        HashMap cMap = this.fOverrideComponentsMap[componentType];
        String cName = DOMUtil.getAttrValue(elem, SchemaSymbols.ATT_NAME);
        if (cMap.get(cName) != null) {
            this.fSchemaHandler.reportSchemaError("sch-props-correct.2", new Object[]{cName}, elem);
        } else {
            OverrideElement e = new OverrideElement(componentType, elem, cName);
            this.fOverrideComponents.add(e);
            cMap.put(cName, e);
        }
    }

    private OverrideElement getMatchingOverrideElement(int componentType, String cName) {
        for (OverrideElement oElem : this.fOverrideComponents) {
            if (oElem.componentType != componentType || !oElem.cName.equals(cName)) continue;
            return oElem;
        }
        return null;
    }

    private int getOverrideType(String localName) {
        if (localName.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            return 1;
        }
        if (localName.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
            return 2;
        }
        if (localName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
            return 3;
        }
        if (localName.equals(SchemaSymbols.ELT_GROUP)) {
            return 4;
        }
        if (localName.equals(SchemaSymbols.ELT_ELEMENT)) {
            return 5;
        }
        if (localName.equals(SchemaSymbols.ELT_NOTATION)) {
            return 6;
        }
        if (localName.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
            return 7;
        }
        return 0;
    }

    private Document cloneOverridenSchema(Element overridenRoot) {
        Document newDoc = this.fDOMImpl.createDocument(null, null, null);
        Node newRoot = newDoc.importNode(overridenRoot, true);
        newDoc.setDocumentURI(overridenRoot.getOwnerDocument().getDocumentURI());
        newDoc.appendChild(newRoot);
        return newDoc;
    }

    private Node getChildClone(Node child) {
        return this.fOverridenDoc.importNode(child, true);
    }

    private void mergeOverride(Element overrideElement) {
        for (OverrideElement oElem : this.fOverrideComponents) {
            if (!oElem.overrideCloned) {
                overrideElement.appendChild(this.getChildClone(oElem.originalElement));
                this.hasPerformedTransformations = true;
                continue;
            }
            oElem.overrideCloned = false;
        }
    }

    private Element performDOMOverride(Element overridenSchemaRoot, Element overrideNode, Element oldNode) {
        Element clonedNode = (Element)this.getChildClone(overrideNode);
        overridenSchemaRoot.replaceChild(clonedNode, oldNode);
        return clonedNode;
    }

    private String getLocalName(Node node) {
        String localName = "";
        localName = DOMUtil.getLocalName(node);
        if (localName.indexOf(":") > -1) {
            return localName.split(":")[1];
        }
        return localName;
    }

    private static final class OverrideElement {
        final int componentType;
        final Element originalElement;
        final String cName;
        boolean overrideCloned = false;

        OverrideElement(int componentType, Element elem, String cName) {
            this.componentType = componentType;
            this.originalElement = elem;
            this.cName = cName;
        }
    }
}

