/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xpath;

import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import org.mule.apache.xerces.xni.NamespaceContext;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xni.XMLAttributes;

class LiteralNode
extends XPathSyntaxTreeNode {
    private String value;
    private boolean isNumeric;

    public LiteralNode(String value, boolean isNumeric) {
        this.value = value;
        this.isNumeric = isNumeric;
    }

    @Override
    public boolean evaluate(QName element, XMLAttributes attributes, NamespaceContext nsContext) throws Exception {
        Object obj = this.getValue(attributes, nsContext);
        if (this.isNumeric) {
            return obj != null && 0.0 != (Double)obj;
        }
        return obj != null;
    }

    @Override
    public Object getValue(XMLAttributes attributes, NamespaceContext nsContext) throws Exception {
        XSSimpleType type = this.isNumeric ? dvFactory.getBuiltInType("double") : dvFactory.getBuiltInType("string");
        return type.validate(this.value, null, null);
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public int getType() {
        return this.isNumeric ? 0 : 1;
    }
}

