/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xpath;

import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.xpath.XPathException;
import org.mule.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import org.mule.apache.xerces.xni.NamespaceContext;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xni.XMLAttributes;

class CastNode
extends XPathSyntaxTreeNode {
    private XSSimpleType castedType;
    private XPathSyntaxTreeNode child;

    public CastNode(XPathSyntaxTreeNode child, QName type) throws XPathException {
        this.child = child;
        if (!"http://www.w3.org/2001/XMLSchema".equals(type.uri)) {
            throw new XPathException("Casted type is not a built-in type");
        }
        this.castedType = dvFactory.getBuiltInType(type.localpart);
        if (this.castedType == null) {
            throw new XPathException("Casted type is not a built-in type");
        }
    }

    @Override
    public boolean evaluate(QName element, XMLAttributes attributes, NamespaceContext nsContext) throws Exception {
        Object obj = this.getValue(attributes, nsContext);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return ((String)obj).length() > 0;
        }
        if (obj instanceof Double) {
            return (Double)obj != 0.0;
        }
        return true;
    }

    @Override
    public Object getValue(XMLAttributes attributes, NamespaceContext nsContext) throws Exception {
        Object obj;
        XSSimpleType type = this.getSimpleType();
        if (this.child.getType() == 2) {
            String attrValue = this.child.getValue(attributes, nsContext).toString();
            obj = type.validate(attrValue, null, null);
        } else {
            obj = type.validate(this.child.getStringValue(), null, null);
        }
        if (type.getNumeric()) {
            obj = dvFactory.getBuiltInType("double").validate(obj, null, null);
        }
        return obj;
    }

    @Override
    public XSSimpleType getSimpleType() {
        return this.castedType;
    }

    @Override
    public int getType() {
        if (this.castedType.getNumeric()) {
            return 0;
        }
        if (this.castedType.getName().equals("string")) {
            return 1;
        }
        return 3;
    }
}

