/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.nio.charset.Charset;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;

public class StringToEnum
extends AbstractTransformer
implements DiscoverableTransformer {
    private final Class<? extends Enum> enumClass;
    private int weighting = 1;

    public StringToEnum(Class<? extends Enum> enumClass) {
        Preconditions.checkArgument((enumClass != null ? 1 : 0) != 0, (String)"enumClass cannot be null");
        this.enumClass = enumClass;
        this.registerSourceType(DataType.fromType(String.class));
        this.setReturnDataType(DataType.fromType(enumClass));
        this.setName(String.format("StringTo%sTransformer", enumClass.getName()));
    }

    @Override
    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            return Enum.valueOf(this.enumClass, (String)src);
        }
        catch (Exception e) {
            throw new TransformerException(I18nMessageFactory.createStaticMessage((String)String.format("Could not transform value '%s' to an enum of type %s", src, this.enumClass.getName())), (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.weighting;
    }

    @Override
    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }
}

